/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.app;

import com.dtyunxi.app.DeployEnv;
import com.dtyunxi.app.ServiceConstants;
import com.dtyunxi.yes.rpc.MicroServiceContext;
import com.dtyunxi.yes.rpc.SpringCloudMicroServiceContext;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContext
implements ServiceConstants {
    private static final Logger log = LoggerFactory.getLogger(ServiceContext.class);
    private static final String EDAS_MICRO_SERVICE_CONTEXT_CLASS = "com.dtyunxi.yes.rpc.EdasMicroServiceContext";
    private MicroServiceContext microServiceContext = null;
    private static final ThreadLocal<ServiceContext> LOCAL = new ThreadLocal<ServiceContext>(){

        @Override
        protected ServiceContext initialValue() {
            return new ServiceContext();
        }
    };
    private final Map<String, Object> mapValue = new ConcurrentHashMap<String, Object>();

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    private MicroServiceContext getMicroServiceContext() {
        if (this.microServiceContext == null) {
            if (DeployEnv.isEdasHsf()) {
                try {
                    this.microServiceContext = (MicroServiceContext)Class.forName(EDAS_MICRO_SERVICE_CONTEXT_CLASS).newInstance();
                }
                catch (Exception e) {
                    log.error("get microService Context", (Throwable)e);
                }
            } else {
                this.microServiceContext = new SpringCloudMicroServiceContext();
            }
        }
        return this.microServiceContext;
    }

    public void removeAttachmentContext() {
        if (this.microServiceContext != null) {
            this.microServiceContext.removeContext();
        }
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.mapValue.remove(key);
        } else {
            this.mapValue.put(key, value);
        }
    }

    public void remove(String key) {
        this.mapValue.remove(key);
    }

    public Object get(String key) {
        return this.mapValue.get(key);
    }

    public Map<String, Object> getKeys() {
        return this.mapValue;
    }

    public void setAttachment(String key, String attachment) {
        this.set(key, attachment);
        this.getMicroServiceContext().setAttachment(key, attachment);
    }

    public String getAttachment(String key) {
        Object value = this.get(key);
        if (value == null) {
            value = this.getMicroServiceContext().getAttachment(key);
        }
        if (Objects.isNull(value) || "null".equals(value)) {
            return null;
        }
        return String.valueOf(value);
    }

    public void removeAttachment(String key) {
        this.remove(key);
        this.getMicroServiceContext().removeAttachment(key);
    }

    public Map<String, String> getAttachments() {
        return this.getMicroServiceContext().getAttachments();
    }

    public String getAppId() {
        return this.getAttachment("dtyunxi.appId");
    }

    public void setAppId(String appId) {
        this.setAttachment("dtyunxi.appId", appId);
    }

    public String getAppSecret() {
        return this.getAttachment("dtyunxi.appSecret");
    }

    public void setAppSecret(String appSecret) {
        this.setAttachment("dtyunxi.appSecret", appSecret);
    }

    public Long getRequestUserId() {
        String userId = this.getAttachment("yes.req.userId");
        if (StringUtils.isNumeric((CharSequence)userId)) {
            return Long.valueOf(userId);
        }
        return null;
    }

    public String getRequestUserCode() {
        return this.getAttachment("yes.req.userCode");
    }

    public Long getRequestApplicationId() {
        String applicationId = this.getAttachment("yes.req.applicationId");
        if (StringUtils.isNumeric((CharSequence)applicationId)) {
            return Long.valueOf(applicationId);
        }
        return null;
    }

    public Long getRequestTenantId() {
        String tenantId = this.getRequestTenantIdString();
        if (StringUtils.isNumeric((CharSequence)tenantId)) {
            return Long.valueOf(tenantId);
        }
        return null;
    }

    public String getRequestTenantIdString() {
        String tenantId = this.getAttachment("yes.req.tenantId");
        if (StringUtils.isNumeric((CharSequence)tenantId)) {
            return tenantId;
        }
        return null;
    }

    public Long getRequestInstanceId() {
        String targetId = this.getAttachment("yes.req.instanceId");
        if (StringUtils.isNumeric((CharSequence)targetId)) {
            return Long.valueOf(targetId);
        }
        return null;
    }

    public Long getRequestUserUnitId() {
        String unitId = this.getAttachment("unitId");
        if (StringUtils.isNumeric((CharSequence)unitId)) {
            return Long.valueOf(unitId);
        }
        return null;
    }

    public Long getRequestTenantCode() {
        String tenantCode = this.getAttachment("yes.req.tenantCode");
        if (StringUtils.isNumeric((CharSequence)tenantCode)) {
            return Long.valueOf(tenantCode);
        }
        return 1L;
    }

    public String getRequestUserIdString() {
        return this.getAttachment("yes.req.userId");
    }

    public String getRequestTerminalTypeString() {
        return this.getAttachment("yes.req.terminal.type");
    }

    public String getRequestId() {
        return this.getAttachment("yes.req.requestId");
    }

    public String getRequestOpenId() {
        return this.getAttachment("yes.req.openId");
    }

    public String getRequestUserType() {
        return this.getAttachment("yes.req.userType");
    }

    public String getRemoteIp() {
        return this.getAttachment("yes.req.remoteIp");
    }
}

