/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LocalIpAddress {
    public static List<InetAddress> resolveLocalAddresses() {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> ns = null;
        try {
            ns = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        while (ns != null && ns.hasMoreElements()) {
            NetworkInterface n = ns.nextElement();
            Enumeration<InetAddress> is = n.getInetAddresses();
            while (is.hasMoreElements()) {
                InetAddress i = is.nextElement();
                if (i.isLoopbackAddress() || i.isLinkLocalAddress() || i.isMulticastAddress() || LocalIpAddress.isSpecialIp(i.getHostAddress())) continue;
                addrs.add(i);
            }
        }
        return addrs;
    }

    public static String resolveLocalIp() {
        List<InetAddress> addrs = LocalIpAddress.resolveLocalAddresses();
        if (!addrs.isEmpty()) {
            return addrs.get(0).getHostAddress();
        }
        return null;
    }

    public static List<String> resolveLocalIps() {
        List<InetAddress> addrs = LocalIpAddress.resolveLocalAddresses();
        ArrayList<String> ret = new ArrayList<String>();
        for (InetAddress addr : addrs) {
            ret.add(addr.getHostAddress());
        }
        return ret;
    }

    private static boolean isSpecialIp(String ip) {
        if (ip.contains(":")) {
            return true;
        }
        if (ip.startsWith("127.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        return ip.equals("255.255.255.255");
    }
}

