/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    public static String SSO_LOGIN_ACCOUNT = "sso.login.account.auth";

    public static void addCookie(HttpServletResponse response, String value, int maxAge) {
        Cookie cookie = new Cookie(SSO_LOGIN_ACCOUNT, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static Cookie getCookieByName(HttpServletRequest request) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie ck : cookies) {
                if (!ck.getName().equals(SSO_LOGIN_ACCOUNT)) continue;
                cookie = ck;
                break;
            }
        }
        return cookie;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie ck : cookies) {
                if (!ck.getName().equals(name)) continue;
                cookie = ck;
                break;
            }
        }
        return cookie;
    }

    public static void delCookieByName(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = CookieUtil.getCookieByName(request);
        if (cookie != null) {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public static void delCookieByName(HttpServletRequest request, String name, HttpServletResponse response) {
        Cookie cookie = CookieUtil.getCookieByName(request, name);
        if (cookie != null) {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }
}

