/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestWrapper.class);
    private final ResettableServletInputStream is = new ResettableServletInputStream();
    private static String charsetName = "UTF-8";

    public HttpRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            String value = values[i];
            value = HttpRequestWrapper.cleanEmoji(value);
            encodedValues[i] = value = this.cleanXSS(value);
        }
        logger.debug("\u8fdb\u5165getParameterValues\u65b9\u6cd5,\u53c2\u6570:{},\u8fd4\u56de:{}", (Object)parameter, (Object)encodedValues);
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        value = HttpRequestWrapper.cleanEmoji(value);
        value = this.cleanXSS(value);
        logger.debug("\u8fdb\u5165getParameter\u65b9\u6cd5,\u53c2\u6570:{},\u8fd4\u56de:{}", (Object)parameter, (Object)value);
        return value;
    }

    public String getQueryString() {
        String value = super.getQueryString();
        if (value == null) {
            return null;
        }
        value = HttpRequestWrapper.cleanEmoji(value);
        value = this.cleanXSS(value);
        logger.debug("\u8fdb\u5165getQueryString\u65b9\u6cd5.\u8fd4\u56de:{}", (Object)value);
        return value;
    }

    public Map<String, String[]> getParameterMap() {
        Map param = super.getParameterMap();
        if (null == param) {
            return null;
        }
        Iterator ite = param.keySet().iterator();
        while (ite.hasNext()) {
            String[] values = (String[])param.get(ite.next());
            if (null == values) continue;
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                value = HttpRequestWrapper.cleanEmoji(value);
                values[i] = value = this.cleanXSS(value);
            }
        }
        logger.debug("\u8fdb\u5165getParameterMap\u65b9\u6cd5.\u8fd4\u56de:{}", (Object)param);
        return param;
    }

    public String getHeader(String name) {
        logger.debug("", (Object)name);
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        value = this.cleanXSS(value);
        logger.debug("\u8fdb\u5165getHeader\u65b9\u6cd5,\u53c2\u6570:{},\u8fd4\u56de:{}", (Object)name, (Object)value);
        return value;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (null == this.is.stream) {
            ServletInputStream sis = super.getInputStream();
            byte[] b = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while (sis.read(b) > 0) {
                String value = new String(b, charsetName);
                value = this.cleanXSS(value);
                value = HttpRequestWrapper.cleanEmoji(value);
                sb.append(value);
            }
            logger.debug("\u8fdb\u5165getInputStream\u65b9\u6cd5.\u5904\u7406\u540e:{}", (Object)sb);
            this.is.stream = new ByteArrayInputStream(sb.toString().getBytes());
        }
        return this.is;
    }

    private String cleanXSS(String value) {
        return value.replaceAll("<", "& lt;").replaceAll(">", "& gt;").replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;").replaceAll("'", "& #39;").replaceAll("eval\\((.*)\\)", "").replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"").replaceAll("script", "");
    }

    private static String cleanEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        String temp = source;
        try {
            temp = URLDecoder.decode(source, charsetName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
        Matcher emojiMatcher = emoji.matcher(temp);
        if (emojiMatcher.find()) {
            String s = emojiMatcher.replaceAll("");
            logger.debug("\u8868\u60c5\u5904\u7406.\u5904\u7406\u524d:{} , \u5904\u7406\u540e{}", (Object)source, (Object)s);
            return s;
        }
        logger.debug("\u8868\u60c5\u5904\u7406.\u672a\u5339\u914d\u7684\u5b57\u7b26\u4e32:{},\u8f6c\u7801\u540e:{}", (Object)source, (Object)temp);
        return source;
    }

    private class ResettableServletInputStream
    extends ServletInputStream {
        private InputStream stream;

        private ResettableServletInputStream() {
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public boolean isFinished() {
            try {
                return this.stream.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

