/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.configuration;

import com.dtyunxi.huieryun.core.support.CustomDateDeserializer;
import com.dtyunxi.huieryun.core.support.CustomDateSerializer;
import com.dtyunxi.huieryun.core.support.CustomLocalDateDeserializer;
import com.dtyunxi.huieryun.core.support.CustomLocalDateTimeDeserializer;
import com.dtyunxi.huieryun.core.support.CustomLocalDateTimeSerializer;
import com.dtyunxi.huieryun.core.support.CustomLocalTimeDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;

public class CustomJacksonAutoConfiguration {
    @Value(value="${spring.jackson.includeNullValueField:true}")
    private Boolean jsonIncludeNullValue = true;
    @Value(value="${cube.response.enable-null-field:true}")
    private Boolean enableNullResponse = true;
    @Value(value="${cube.json.date-format:yyyy-MM-dd HH:mm:ss}")
    private String jsonDateFormat;
    @Value(value="${cube.json.time-zone:GMT+8}")
    private String jsonTimeZone;

    @Bean
    @ConditionalOnProperty(prefix="cube.json", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public Jackson2ObjectMapperBuilderCustomizer defaultJackson2ObjectMapperBuilderCustomizer() {
        return builder -> {
            builder.serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)CustomLocalDateTimeSerializer.instance.setDateFormat(this.jsonDateFormat));
            builder.serializerByType(Date.class, (JsonSerializer)CustomDateSerializer.instance.setDateFormat(this.jsonDateFormat));
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)CustomLocalDateTimeDeserializer.instance);
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)CustomLocalDateDeserializer.instance);
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)CustomLocalTimeDeserializer.instance);
            builder.deserializerByType(Date.class, (JsonDeserializer)CustomDateDeserializer.instance);
            builder.failOnEmptyBeans(false);
            builder.failOnUnknownProperties(false);
            if (!this.jsonIncludeNullValue.booleanValue() && !this.enableNullResponse.booleanValue()) {
                builder.serializationInclusion(JsonInclude.Include.NON_NULL);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.jsonDateFormat);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.jsonTimeZone));
            builder.dateFormat((DateFormat)simpleDateFormat);
        };
    }
}

