/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.exception;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.huieryun.core.constant.Code;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class CommonException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Throwable cause;
    @JSONField(serialize=false)
    private final int code;
    @JSONField(name="rawMessage")
    private final String message;

    public CommonException(CommonException exception) {
        this.message = exception.getMessage();
        this.code = exception.getCode();
        this.cause = exception;
    }

    public CommonException(Code code, Object ... args) {
        this(null, code, args);
    }

    public CommonException(Integer code, String message) {
        this(null, code, message);
    }

    public CommonException(Throwable cause, Code code) {
        this.message = code.getMessage();
        this.code = code.getCode();
        this.cause = cause;
    }

    public CommonException(Throwable cause, int code, String msg) {
        this.message = msg;
        this.code = code;
        this.cause = cause;
    }

    public CommonException(Throwable cause, Code code, Object ... args) {
        String tmp;
        this.message = tmp = String.format(code.getMessage(), args);
        this.code = code.getCode();
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    @JSONField(name="code")
    public String getRawCode() {
        return String.valueOf(this.code);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{cause=").append(this.cause);
        sb.append(", code=").append(this.code);
        sb.append(", message='").append(this.message).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

