/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.model.result;

import com.dtyunxi.huieryun.core.constant.Code;
import com.dtyunxi.huieryun.core.model.Version;
import java.io.Serializable;
import java.util.Objects;

public class ResultHeader
implements Serializable {
    private static final long serialVersionUID = -7196527092849550024L;
    private int code;
    private String name;
    private String message;
    private String traceId;
    private Version version;

    public ResultHeader() {
    }

    public ResultHeader(Code code) {
        this.code = code.getCode();
        this.name = code.getName();
        this.message = code.getMessage();
    }

    public static ResultHeader of(int code, String name, String message) {
        ResultHeader header = new ResultHeader();
        header.setCode(code);
        header.setName(name);
        header.setMessage(message);
        return header;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("  \"code\":").append(this.code);
        sb.append(", \"name\":\"").append(this.name).append('\"');
        sb.append(", \"message\":\"").append(this.message).append('\"');
        sb.append(", \"version\":").append(this.version);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultHeader that = (ResultHeader)o;
        return this.code == that.code && Objects.equals(this.name, that.name) && Objects.equals(this.message, that.message) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.message, this.version);
    }

    public static ResultHeaderBuilder builder() {
        return new ResultHeaderBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public ResultHeader(int code, String name, String message, String traceId, Version version) {
        this.code = code;
        this.name = name;
        this.message = message;
        this.traceId = traceId;
        this.version = version;
    }

    public static class ResultHeaderBuilder {
        private int code;
        private String name;
        private String message;
        private String traceId;
        private Version version;

        ResultHeaderBuilder() {
        }

        public ResultHeaderBuilder code(int code) {
            this.code = code;
            return this;
        }

        public ResultHeaderBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ResultHeaderBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ResultHeaderBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public ResultHeaderBuilder version(Version version) {
            this.version = version;
            return this;
        }

        public ResultHeader build() {
            return new ResultHeader(this.code, this.name, this.message, this.traceId, this.version);
        }

        public String toString() {
            return "ResultHeader.ResultHeaderBuilder(code=" + this.code + ", name=" + this.name + ", message=" + this.message + ", traceId=" + this.traceId + ", version=" + this.version + ")";
        }
    }
}

