/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;

public class CustomDateSerializer
extends JsonSerializer<Date> {
    @Value(value="${spring.jackson.useTimestamp:false}")
    private boolean useTimestamp = false;
    private ThreadLocal<SimpleDateFormat> dateThreadLocal;
    public static final CustomDateSerializer instance = new CustomDateSerializer();

    public void serialize(Date date, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new DateSerializer(Boolean.valueOf(this.useTimestamp), this.getCustomFormat()).serialize(date, gen, serializers);
    }

    @Value(value="${spring.jackson.dateFormat}")
    public CustomDateSerializer setDateFormat(String dateFormat) {
        this.dateThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat(dateFormat));
        return this;
    }

    public DateFormat getCustomFormat() {
        if (this.dateThreadLocal == null) {
            this.dateThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return this.dateThreadLocal.get();
    }
}

