/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Value;

public class CustomLocalDateTimeSerializer
extends JsonSerializer<LocalDateTime> {
    public static final CustomLocalDateTimeSerializer instance = new CustomLocalDateTimeSerializer();
    @Value(value="${spring.jackson.dateFormat}")
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(this.dateFormat)).serialize(value, gen, serializers);
    }

    public CustomLocalDateTimeSerializer setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }
}

