/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class CustomLocalTimeDeserializer
extends JsonDeserializer<LocalTime> {
    public static final CustomLocalTimeDeserializer instance = new CustomLocalTimeDeserializer();

    public LocalTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getText();
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        LocalTime localdTime = UnixTimeConverter.getLocalTimeFromUnixTime(value);
        if (localdTime != null) {
            return localdTime;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (null != meta) {
            return new LocalTimeDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
        }
        return new LocalTimeDeserializer(DateTimeFormatter.ISO_LOCAL_TIME).deserialize(jsonParser, deserializationContext);
    }
}

