/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import java.time.format.DateTimeFormatter;

public class LocalDateTimeMeta {
    public static final int TYPE_LOCALDATETIME = 1;
    public static final int TYPE_LOCALDATE = 2;
    public static final int TYPE_LOCALTIME = 3;
    private int type;
    private DateTimeFormatter formatter;

    LocalDateTimeMeta(int type, DateTimeFormatter formatter) {
        this.type = type;
        this.formatter = formatter;
    }

    LocalDateTimeMeta(int type, String style) {
        this.type = type;
        this.formatter = DateTimeFormatter.ofPattern(style);
    }

    public static LocalDateTimeMeta getMeta(String value) {
        boolean isTight;
        if (value == null) {
            return null;
        }
        value = value.trim();
        int len = value.length();
        boolean hasDash = value.indexOf("-") > -1;
        boolean hasSlash = value.indexOf("/") > -1;
        boolean hasSpace = value.indexOf(" ") > -1;
        boolean hasColon = value.indexOf(":") > -1;
        boolean hasT = value.indexOf("T") > -1;
        boolean bl = isTight = !hasSlash && !hasDash && !hasSpace && !hasColon;
        if (isTight && len == 6) {
            return new LocalDateTimeMeta(3, "HHmmss");
        }
        if (hasColon && !isTight && len >= 5 && len <= 8) {
            return new LocalDateTimeMeta(3, DateTimeFormatter.ISO_LOCAL_TIME);
        }
        if (isTight && len == 8) {
            return new LocalDateTimeMeta(2, "yyyyMMdd");
        }
        if (isTight && len == 14) {
            return new LocalDateTimeMeta(1, "yyyyMMddHHmmss");
        }
        if (isTight && len == 15 && hasT) {
            return new LocalDateTimeMeta(1, "yyyyMMddTHHmmss");
        }
        if (!isTight && len == 10 && hasDash) {
            return new LocalDateTimeMeta(2, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        if (!isTight && len == 10 && hasSlash) {
            return new LocalDateTimeMeta(2, "yyyy/MM/dd");
        }
        if (!isTight && len == 19 && hasDash && hasColon) {
            return new LocalDateTimeMeta(1, "yyyy-MM-dd HH:mm:ss");
        }
        if (!isTight && len == 19 && hasSlash && hasColon) {
            return new LocalDateTimeMeta(1, "yyyy/MM/dd HH:mm:ss");
        }
        if (!isTight && len == 19 && hasSlash && hasColon && hasT) {
            return new LocalDateTimeMeta(1, "yyyy/MM/ddTHH:mm:ss");
        }
        if (!isTight && len == 19 && hasDash && hasColon && hasT) {
            return new LocalDateTimeMeta(1, "yyyy/MM/ddTHH:mm:ss");
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalDateTimeMeta)) {
            return false;
        }
        LocalDateTimeMeta other = (LocalDateTimeMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        DateTimeFormatter this$formatter = this.getFormatter();
        DateTimeFormatter other$formatter = other.getFormatter();
        return !(this$formatter == null ? other$formatter != null : !this$formatter.equals(other$formatter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalDateTimeMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        DateTimeFormatter $formatter = this.getFormatter();
        result = result * 59 + ($formatter == null ? 43 : $formatter.hashCode());
        return result;
    }

    public String toString() {
        return "LocalDateTimeMeta(type=" + this.getType() + ", formatter=" + this.getFormatter() + ")";
    }
}

