/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class Time {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final List<DateTimeFormatter> LOCAL_DATE_TIME_FORMATTERS = Lists.newArrayList();
    private static final List<DateTimeFormatter> ZONED_DATE_TIME_FORMATTERS;

    public static Date getUtcBeginTime() {
        return new Date(-28800000L);
    }

    public static Date getLocalDate(int timestamp) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.add(14, TimeZone.getDefault().getRawOffset());
        calendar.add(13, timestamp);
        return calendar.getTime();
    }

    public static String getTimeFormatString(Date currentTime) {
        return Time.getTimeFormatString(currentTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getTimeFormatString(LocalDateTime currentTime) {
        return currentTime.atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String getTimeFormatString(Date currentTime, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(currentTime);
    }

    public static Date parseDate(String string) {
        return Date.from(Time.parseLocalDateTime(string, TimeZone.getDefault().getID()).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime parseLocalDateTime(String string, String defaultTimezoneId) {
        if (string != null && string.length() >= 10) {
            switch (string.length()) {
                case 10: {
                    try {
                        LocalDateTime localDateTime = Time.parseBeginTime(string);
                        if (localDateTime != null) {
                            return localDateTime;
                        }
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 19: {
                    for (DateTimeFormatter dateTimeFormatter : LOCAL_DATE_TIME_FORMATTERS) {
                        try {
                            if (TimeZone.getDefault().getID().equals(defaultTimezoneId)) {
                                return LocalDateTime.parse(string, dateTimeFormatter);
                            }
                            return LocalDateTime.parse(string, dateTimeFormatter).atZone(ZoneId.of(defaultTimezoneId)).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                        }
                        catch (Exception exception) {
                        }
                    }
                    break;
                }
                default: {
                    for (DateTimeFormatter dateTimeFormatter : ZONED_DATE_TIME_FORMATTERS) {
                        try {
                            return ZonedDateTime.parse(string, dateTimeFormatter).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
        }
        throw new RuntimeException("error dateTime format: " + string);
    }

    public static LocalDateTime parseBeginTime(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            if (!string.contains(":")) {
                string = string + " 00:00:00";
            }
            return LocalDateTime.parse(string, DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDateTime parseEndTime(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            if (!string.contains(":")) {
                string = string + " 00:00:00";
                return LocalDateTime.parse(string, DATE_TIME_FORMATTER).plusDays(1L);
            }
            return LocalDateTime.parse(string, DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRelativeTimeString(String exp) {
        return Time.getTimeFormatString(Time.getRelativeTime(exp));
    }

    public static LocalDateTime getRelativeTime(String exp) {
        ArrayList<String> units = new ArrayList<String>(Arrays.asList("y", "M", "d", "h", "m", "s", "\u5e74", "\u6708", "\u65e5", "\u65f6", "\u5206", "\u79d2"));
        String unit = "d";
        for (String tmpUnit : units) {
            if (!exp.endsWith(tmpUnit)) continue;
            unit = tmpUnit;
            exp = exp.substring(0, exp.length() - 1);
            break;
        }
        switch (unit) {
            case "y": 
            case "\u5e74": {
                return LocalDateTime.now().plusYears(Long.parseLong(exp));
            }
            case "M": 
            case "\u6708": {
                return LocalDateTime.now().plusMonths(Long.parseLong(exp));
            }
            case "h": 
            case "\u65f6": {
                return LocalDateTime.now().plusHours(Long.parseLong(exp));
            }
            case "m": 
            case "\u5206": {
                return LocalDateTime.now().plusMinutes(Long.parseLong(exp));
            }
            case "s": 
            case "\u79d2": {
                return LocalDateTime.now().plusSeconds(Long.parseLong(exp));
            }
        }
        return LocalDateTime.now().plusDays(Long.parseLong(exp));
    }

    static {
        LOCAL_DATE_TIME_FORMATTERS.add(DATE_TIME_FORMATTER);
        LOCAL_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        ZONED_DATE_TIME_FORMATTERS = Lists.newArrayList();
        ZONED_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ISO_DATE_TIME);
        ZONED_DATE_TIME_FORMATTERS.add(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

