/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util.lambda;

import com.dtyunxi.huieryun.core.util.lambda.LambdaFunction;
import com.dtyunxi.huieryun.core.util.lambda.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LambdaUtils {
    private static final Map<Class<?>, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap();

    public static <T> SerializedLambda resolve(Function<T, ?> func) {
        Class<?> clazz = func.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(clazz, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static <T> String getProperty(LambdaFunction<T, ?> propertyFunctions) {
        SerializedLambda serializedLambda = LambdaUtils.resolve(propertyFunctions);
        return serializedLambda.methodToProperty(serializedLambda.getImplMethodName());
    }
}

