/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.model.base;

import com.dtyunxi.huieryun.core.assembler.Assembler;
import com.dtyunxi.huieryun.core.util.JSON;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRef<T extends Serializable>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BaseRef.class);
    private static final long serialVersionUID = 7492291103193438975L;
    private T id;
    private String code;
    private String name;
    private Map<String, Object> other;

    public T getId() {
        return this.id;
    }

    public void setId(T id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setOtherValue(String key, Object value) {
        if (this.other == null) {
            this.other = new HashMap<String, Object>();
        }
        this.other.put(key, value);
    }

    protected <V> V getOtherValue(String key, Class<V> clazz) {
        if (this.other == null) {
            return null;
        }
        Object value = this.other.get(key);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        V result = null;
        try {
            result = Assembler.assemble(clazz, value);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        if (result != null) {
            return result;
        }
        String json = JSON.toJsonString(value);
        try {
            return JSON.parseObject(json, clazz);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
            return null;
        }
    }
}

