/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.model.result;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.huieryun.core.constant.Code;
import com.dtyunxi.huieryun.core.constant.CommCode;
import com.dtyunxi.huieryun.core.model.result.ResultHeader;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -2341974315337708093L;
    @JSONField(serialize=false)
    private ResultHeader header;
    @JSONField(name="data")
    private T body = null;
    @JSONField(serialize=false)
    private Map<String, Object> extension;
    @JSONField(serialize=false)
    private Throwable throwable;

    protected Result() {
        this.header = new ResultHeader(CommCode.SUCCESS);
        this.extension = new HashMap<String, Object>();
    }

    private Result(ResultHeader header, T body, Map<String, Object> extension, Throwable throwable) {
        this.header = header;
        this.extension = (Map)ObjectUtils.defaultIfNull(extension, new HashMap());
        this.throwable = throwable;
        this.body = body;
    }

    public static <T> Result<T> build() {
        return new Result<Object>(new ResultHeader(CommCode.SUCCESS), null, null, null);
    }

    @JSONField(serialize=false)
    public boolean isSuccess() {
        return CommCode.SUCCESS.getCode().equals(this.header.getCode());
    }

    public static <T> T ofNullable(Result<T> result) {
        if (result == null || !result.isSuccess()) {
            return null;
        }
        return result.getBody();
    }

    public static <T> T ofNullable(Result<T> result, T value) {
        if (result == null || !result.isSuccess()) {
            return value;
        }
        return result.getBody();
    }

    public static <T> Result<T> build(Code code) {
        return new Result<Object>(new ResultHeader(code), null, null, null);
    }

    public static <T> Result<T> build(ResultHeader header) {
        return new Result<Object>(header, null, null, null);
    }

    public static <T> Result<T> build(T body) {
        return new Result<T>(new ResultHeader(CommCode.SUCCESS), body, null, null);
    }

    public static <T> Result<T> build(Code code, T body) {
        return new Result<T>(new ResultHeader(code), body, null, null);
    }

    public static <T> Result<T> build(Code code, T body, Map<String, Object> extension) {
        return new Result<T>(new ResultHeader(code), body, extension, null);
    }

    public static <T> Result<T> build(Code code, T body, Map<String, Object> extension, Throwable throwable) {
        return new Result<T>(new ResultHeader(code), body, extension, throwable);
    }

    @JsonIgnore
    public String getResultCode() {
        int code = this.header.getCode() - Code.COMM_BASE;
        switch (code) {
            case 0: {
                return "0";
            }
            case 1: {
                return "100000";
            }
        }
        return String.valueOf(code);
    }

    @JsonIgnore
    public String getResultMsg() {
        int code = this.header.getCode() - Code.COMM_BASE;
        switch (code) {
            case 0: {
                return "success";
            }
            case 1: {
                return "fail";
            }
        }
        return this.header.getMessage();
    }

    public ResultHeader getHeader() {
        return this.header;
    }

    public T getBody() {
        return this.body;
    }

    public Map<String, Object> getExtension() {
        return this.extension;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Result<T> setHeader(ResultHeader header) {
        this.header = header;
        return this;
    }

    public Result<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public Result<T> setExtension(Map<String, Object> extension) {
        this.extension = extension;
        return this;
    }

    public Result<T> setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }
}

