/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;

public class CustomDateDeserializer
extends JsonDeserializer<Date> {
    public static final CustomDateDeserializer instance = new CustomDateDeserializer();

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getText();
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        Date date = UnixTimeConverter.getDateFromUnixTime(value);
        if (date != null) {
            return date;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (meta == null) {
            return new DateDeserializers.DateDeserializer().deserialize(jsonParser, deserializationContext);
        }
        switch (meta.getType()) {
            case 1: {
                LocalDateTime localDateTime = new LocalDateTimeDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
                return Date.from(localDateTime.toInstant(ZoneOffset.ofHours(8)));
            }
            case 2: {
                LocalDate localDate = new LocalDateDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
                return Date.from(localDate.atStartOfDay().toInstant(ZoneOffset.ofHours(8)));
            }
            case 3: {
                LocalTime localTime = new LocalTimeDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
                LocalDateTime localDateTime2 = LocalDateTime.of(LocalDate.now(), localTime);
                return Date.from(localDateTime2.toInstant(ZoneOffset.ofHours(8)));
            }
        }
        return new DateDeserializers.DateDeserializer().deserialize(jsonParser, deserializationContext);
    }
}

