/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class CustomLocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public static final CustomLocalDateTimeDeserializer instance = new CustomLocalDateTimeDeserializer();

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getText();
        LocalDateTime epochSecond = UnixTimeConverter.getLocalDateTimeFromUnixTime(value);
        if (epochSecond != null) {
            return epochSecond;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (null != meta) {
            return new LocalDateTimeDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
        }
        return new LocalDateTimeDeserializer(DateTimeFormatter.ISO_LOCAL_DATE_TIME).deserialize(jsonParser, deserializationContext);
    }
}

