/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class StringToLocalTimeConverter
implements Converter<String, LocalTime> {
    private static final Logger log = LoggerFactory.getLogger(StringToLocalTimeConverter.class);

    public LocalTime convert(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        LocalTime localdTime = UnixTimeConverter.getLocalTimeFromUnixTime(value);
        if (localdTime != null) {
            return localdTime;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (null != meta) {
            return LocalTime.parse(value, meta.getFormatter());
        }
        log.warn("\u65e0\u6cd5\u8bc6\u522b\u7684\u683c\u5f0f\uff0c\u503c\uff1a{}", (Object)value);
        return LocalTime.parse(value);
    }
}

