/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;

public class UnixTimeConverter {
    public static LocalDateTime getLocalDateTimeFromUnixTime(String value) {
        if (NumberUtil.isNumber((CharSequence)value) && (value.length() == 10 || value.length() == 13)) {
            if (StrUtil.length((CharSequence)value) > 10) {
                Long epochSecond = Long.valueOf(value.substring(0, 10));
                Integer nanoOfSecond = Integer.valueOf(value.substring(10)) * 1000000;
                return LocalDateTime.ofEpochSecond(epochSecond, nanoOfSecond, ZoneOffset.ofHours(8));
            }
            return LocalDateTime.ofEpochSecond(Long.valueOf(value), 0, ZoneOffset.ofHours(8));
        }
        return null;
    }

    public static LocalDate getLocalDateFromUnixTime(String value) {
        if (NumberUtil.isNumber((CharSequence)value) && (value.length() == 10 || value.length() == 13)) {
            return LocalDate.ofEpochDay(Long.valueOf(value));
        }
        return null;
    }

    public static LocalTime getLocalTimeFromUnixTime(String value) {
        if (NumberUtil.isNumber((CharSequence)value) && value.length() < 6) {
            return LocalTime.ofSecondOfDay(Long.valueOf(value));
        }
        return null;
    }

    public static Date getDateFromUnixTime(String value) {
        if (NumberUtil.isNumber((CharSequence)value) && (value.length() == 10 || value.length() == 13)) {
            if (StrUtil.length((CharSequence)value) > 10) {
                return new Date(Long.valueOf(value));
            }
            return new Date(Long.valueOf(value) * 1000L);
        }
        return null;
    }
}

