/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.assembler;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.huieryun.core.assembler.AssemblerCallBack;
import com.dtyunxi.huieryun.core.model.page.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public class Assembler {
    private static final ConcurrentMap<String, BeanCopier> beanCopierMap = new ConcurrentHashMap<String, BeanCopier>();

    public static BeanCopier getBeanCopier(Class<?> source, Class<?> target, boolean useConverter) {
        String beanCopierKey = source.getSimpleName() + "@" + target.getName() + "@conv" + (useConverter ? "T" : "F");
        BeanCopier beanCopier = beanCopierMap.getOrDefault(beanCopierKey, BeanCopier.create(source, target, (boolean)false));
        beanCopierMap.putIfAbsent(beanCopierKey, beanCopier);
        return beanCopier;
    }

    public static <T> T assemble(Class<T> target, Object source) {
        return Assembler.assemble(target, source, null, null);
    }

    public static <T> T assemble(Class<T> target, Object source, Converter converter) {
        return Assembler.assemble(target, source, null, converter);
    }

    public static <T> T assemble(Class<T> target, Object source, AssemblerCallBack callBack) {
        return Assembler.assemble(target, source, callBack, null);
    }

    public static <T> T assemble(Class<T> target, Object source, AssemblerCallBack callBack, Converter converter) {
        if (source == null) {
            return null;
        }
        try {
            BeanCopier beanCopier = null;
            beanCopier = converter == null ? Assembler.getBeanCopier(source.getClass(), target, false) : Assembler.getBeanCopier(source.getClass(), target, true);
            T t = target.newInstance();
            beanCopier.copy(source, t, converter);
            if (callBack != null) {
                callBack.afterAssemble(t, source);
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class:" + target.getName() + " ", e);
        }
    }

    public static <T> List<T> multiAssemble(Class<T> target, Collection<?> sources) {
        return Assembler.multiAssemble(target, sources, null, null);
    }

    public static <T> List<T> multiAssemble(Class<T> target, Collection<?> sources, Converter converter) {
        return Assembler.multiAssemble(target, sources, null, converter);
    }

    public static <T> List<T> multiAssemble(Class<T> target, Collection<?> sources, AssemblerCallBack callBack) {
        return Assembler.multiAssemble(target, sources, callBack, null);
    }

    public static <T> List<T> multiAssemble(Class<T> target, Collection<?> sources, AssemblerCallBack callBack, Converter converter) {
        ArrayList<T> targets = new ArrayList<T>(sources.size());
        if (CollectionUtil.isEmpty(sources)) {
            return targets;
        }
        try {
            BeanCopier beanCopier = null;
            beanCopier = converter == null ? Assembler.getBeanCopier(sources.toArray()[0].getClass(), target, false) : Assembler.getBeanCopier(sources.toArray()[0].getClass(), target, true);
            for (Object object : sources) {
                T t = target.newInstance();
                beanCopier.copy(object, t, converter);
                if (callBack != null) {
                    callBack.afterAssemble(t, object);
                }
                targets.add(t);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class:" + target.getName() + " ", e);
        }
        return targets;
    }

    public static <T> Page<T> pageAssemble(Class<T> target, Page<?> page) {
        if (page == null) {
            return new Page();
        }
        List<Object> tList = null;
        tList = CollectionUtil.isEmpty(page.getRecords()) ? new ArrayList(0) : Assembler.multiAssemble(target, page.getRecords());
        Page result = new Page();
        result.setCurrent(page.getCurrent());
        result.setPages(page.getPages());
        result.setTotal(page.getTotal());
        result.setSize(page.getSize());
        result.setRecords(tList);
        return result;
    }
}

