/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.configuration;

import com.dtyunxi.huieryun.core.model.Application;
import com.dtyunxi.huieryun.core.model.ApplicationInfo;
import com.dtyunxi.huieryun.core.model.Version;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

public class EnvironmentConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${eureka.instance.instance-id:}")
    private String instanceId;
    @Value(value="${spring.cloud.client.hostname}:${spring.application.name}:${spring.application.instance_id:${server.port}}")
    private String defInstanceId;
    @Value(value="${version}")
    private String version;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public Application application() {
        ApplicationInfo application = new ApplicationInfo();
        application.setName(this.applicationName);
        application.setDisplayName(this.applicationContext.getDisplayName());
        application.setVersion(Version.of(this.version));
        application.setInstanceId(this.getInstanceId());
        return application;
    }

    private String getInstanceId() {
        if (StringUtils.isEmpty((Object)this.instanceId)) {
            return this.defInstanceId;
        }
        return this.instanceId;
    }
}

