/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util.id;

import com.dtyunxi.huieryun.core.util.RandomUtil;
import com.dtyunxi.huieryun.core.util.id.SnowflakeIdGenerator;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

@FunctionalInterface
public interface IDGenerator<T> {
    public static final IDGenerator<String> UUID = () -> java.util.UUID.randomUUID().toString();
    public static final IDGenerator<String> RANDOM = () -> RandomUtil.randomStringWithAllChar(8);
    public static final IDGenerator<String> MD5 = () -> {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(UUID.generate().concat(RandomUtil.randomStringWithAllChar(8)).getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    };
    public static final IDGenerator<Long> SNOW_FLAKE = SnowflakeIdGenerator.getInstance()::nextId;
    public static final IDGenerator<String> SNOW_FLAKE_STRING = () -> String.valueOf(SNOW_FLAKE.generate());
    public static final IDGenerator<String> SNOW_FLAKE_HEX = () -> Long.toHexString(SNOW_FLAKE.generate());

    public T generate();
}

