/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.query;

import com.dtyunxi.huieryun.dao.query.QueryExpressionToken;
import java.util.ArrayList;
import java.util.List;

class QueryExpressionTokenParser {
    QueryExpressionTokenParser() {
    }

    List<QueryExpressionToken> parse(String queryString) {
        char[] chars = queryString.trim().toCharArray();
        State state = new ExpressionStateExpression();
        ArrayList<QueryExpressionToken> states = new ArrayList<QueryExpressionToken>();
        for (char aChar : chars) {
            State next = ((State)state).nextChar(aChar);
            if (state.isFinished()) {
                states.add(state);
            }
            state = next;
        }
        if (!state.close().isFinished()) {
            throw new RuntimeException("Last parsed state '" + state.toString() + "' is not finished.");
        }
        states.add(state);
        return states;
    }

    private class RwsState
    extends State {
        private RwsState() {
        }

        @Override
        public State nextChar(char c) {
            if (RwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            if (c == 'O') {
                return new OrState(c);
            }
            if (c == 'A') {
                return new AndState(c);
            }
            return new ExpressionStateExpression().init(c);
        }
    }

    private class BeforeExpressionRwsStateExpression
    extends State {
        private BeforeExpressionRwsStateExpression() {
        }

        @Override
        public State nextChar(char c) {
            if (BeforeExpressionRwsStateExpression.isWhitespace(c)) {
                return this.allowed(c);
            }
            return new ExpressionStateExpression().init(c);
        }
    }

    private class OrState
    extends LiteralState {
        public OrState(char c) {
            super(QueryExpressionToken.Token.OR, c);
            if (c != 'O') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.literal.length() == 1 && c == 'R') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && OrState.isWhitespace(c)) {
                this.finish();
                return new BeforeExpressionRwsStateExpression();
            }
            if (OrState.isWhitespace(c)) {
                this.changeToken(QueryExpressionToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new WordStateExpression(this);
        }

        @Override
        public State close() {
            if (QueryExpressionToken.Token.OR.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(QueryExpressionToken.Token.WORD).finish();
        }
    }

    private class AndState
    extends LiteralState {
        public AndState(char c) {
            super(QueryExpressionToken.Token.AND, c);
            if (c != 'A') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.literal.length() == 1 && c == 'N') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && c == 'D') {
                return this.allowed(c);
            }
            if (this.literal.length() == 3 && AndState.isWhitespace(c)) {
                this.finish();
                return new BeforeExpressionRwsStateExpression();
            }
            if (AndState.isWhitespace(c)) {
                this.changeToken(QueryExpressionToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new WordStateExpression(this);
        }

        @Override
        public State close() {
            if (QueryExpressionToken.Token.AND.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(QueryExpressionToken.Token.WORD).finish();
        }
    }

    private class CloseState
    extends State {
        public CloseState() {
            super(QueryExpressionToken.Token.CLOSE, true);
        }

        @Override
        public State nextChar(char c) {
            return new ExpressionStateExpression().init(c);
        }
    }

    private class OpenState
    extends State {
        public OpenState() {
            super(QueryExpressionToken.Token.OPEN, true);
        }

        @Override
        public State nextChar(char c) {
            this.finish();
            if (OpenState.isWhitespace(c)) {
                return this.forbidden(c);
            }
            return new ExpressionStateExpression().init(c);
        }
    }

    private class WordStateExpression
    extends LiteralState {
        public WordStateExpression(char c) {
            super(QueryExpressionToken.Token.WORD, c);
            if (!WordStateExpression.isAllowedWord(c)) {
                this.forbidden(c);
            }
        }

        public WordStateExpression(State toConsume) {
            super(QueryExpressionToken.Token.WORD, toConsume.getLiteral());
            for (int i = 0; i < this.literal.length(); ++i) {
                if (WordStateExpression.isAllowedWord(this.literal.charAt(i))) continue;
                this.forbidden(this.literal.charAt(i));
            }
        }

        @Override
        public State nextChar(char c) {
            if (WordStateExpression.isAllowedWord(c)) {
                return this.allowed(c);
            }
            if (c == ')') {
                this.finish();
                return new CloseState();
            }
            if (WordStateExpression.isWhitespace(c)) {
                this.finish();
                return new RwsState();
            }
            return this.forbidden(c);
        }

        @Override
        public State finish() {
            String tmpLiteral = this.literal.toString();
            if (tmpLiteral.length() == 3) {
                if (QueryExpressionToken.Token.AND.name().equals(tmpLiteral)) {
                    return this.finishAs(QueryExpressionToken.Token.AND);
                }
            } else if (tmpLiteral.length() == 2 && QueryExpressionToken.Token.OR.name().equals(tmpLiteral)) {
                return this.finishAs(QueryExpressionToken.Token.OR);
            }
            return super.finish();
        }

        @Override
        public State close() {
            return this.finish();
        }
    }

    private class TermStateExpression
    extends LiteralState {
        private TermStateExpression() {
        }

        @Override
        public State nextChar(char c) {
            if (TermStateExpression.isAllowedWord(c)) {
                return new WordStateExpression(c);
            }
            return this.forbidden(c);
        }

        @Override
        public State init(char c) {
            return this.nextChar(c);
        }
    }

    private class ExpressionStateExpression
    extends LiteralState {
        private ExpressionStateExpression() {
        }

        @Override
        public State nextChar(char c) {
            if (c == '(') {
                return new OpenState();
            }
            if (ExpressionStateExpression.isWhitespace(c)) {
                return new RwsState();
            }
            if (c == ')') {
                return new CloseState();
            }
            return new TermStateExpression().init(c);
        }

        @Override
        public State init(char c) {
            return this.nextChar(c);
        }
    }

    private static abstract class LiteralState
    extends State {
        protected final StringBuilder literal = new StringBuilder();

        public LiteralState() {
        }

        public LiteralState(QueryExpressionToken.Token t, char c) {
            super(t);
            this.init(c);
        }

        public LiteralState(QueryExpressionToken.Token t, String initLiteral) {
            super(t);
            this.literal.append(initLiteral);
        }

        @Override
        public State allowed(char c) {
            this.literal.append(c);
            return this;
        }

        @Override
        public String getLiteral() {
            return this.literal.toString();
        }

        public State init(char c) {
            if (this.isFinished()) {
                throw new RuntimeException(this.toString() + " is already finished.");
            }
            this.literal.append(c);
            return this;
        }
    }

    private static abstract class State
    implements QueryExpressionToken {
        protected static final char CHAR_N = 'N';
        protected static final char CHAR_O = 'O';
        protected static final char CHAR_A = 'A';
        protected static final char CHAR_D = 'D';
        protected static final char CHAR_R = 'R';
        protected static final char CHAR_CLOSE = ')';
        protected static final char CHAR_OPEN = '(';
        private QueryExpressionToken.Token token = null;
        private boolean finished = false;

        public State() {
        }

        public State(QueryExpressionToken.Token t) {
            this.token = t;
        }

        public State(QueryExpressionToken.Token t, boolean finished) {
            this(t);
            this.finished = finished;
        }

        static boolean isAllowedWord(char character) {
            return character != ' ' && character != ')' && character != '(';
        }

        static boolean isWhitespace(char character) {
            return character == ' ' || character == '\t';
        }

        protected abstract State nextChar(char var1);

        public State allowed(char c) {
            return this;
        }

        public State forbidden(char c) {
            throw new RuntimeException("Forbidden character in state " + (Object)((Object)this.token) + "->" + c);
        }

        public State invalid() {
            throw new RuntimeException("Token " + (Object)((Object)this.token) + " is in invalid state.");
        }

        public State finish() {
            this.finished = true;
            return this;
        }

        public State finishAs(QueryExpressionToken.Token token) {
            this.finished = true;
            return this.changeToken(token);
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public QueryExpressionToken.Token getToken() {
            return this.token;
        }

        public String getTokenName() {
            if (this.token == null) {
                return "NULL";
            }
            return this.token.name();
        }

        public State close() {
            return this;
        }

        protected State changeToken(QueryExpressionToken.Token token) {
            this.token = token;
            return this;
        }

        @Override
        public String getLiteral() {
            return this.token.toString();
        }

        public String toString() {
            return (Object)((Object)this.token) + "=>{" + this.getLiteral() + "}";
        }
    }
}

