/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.CustomTableInfo;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import java.lang.reflect.Field;

public class CustomQueryWrapper<T>
extends QueryWrapper<T> {
    public CustomQueryWrapper() {
    }

    public CustomQueryWrapper(Class<T> tClass) {
        super.setEntityClass(tClass);
    }

    public CustomQueryWrapper(T entity) {
        this.setEntity(entity);
    }

    public CustomQueryWrapper(T entity, String ... columns) {
        this.setEntity(entity);
        this.select(columns);
    }

    public QueryWrapper<T> setEntity(T entity) {
        CustomTableInfo tableInfo = BaseEoUtil.tableInfo(entity.getClass().getName());
        if (ObjectUtil.isNotNull((Object)tableInfo)) {
            tableInfo.getColumns().forEach(customColumnInfo -> {
                if (customColumnInfo.isStringField()) {
                    Field field = customColumnInfo.getField();
                    field.setAccessible(true);
                    try {
                        Object value = field.get(entity);
                        if (value != null && StrUtil.isBlankIfStr((Object)value)) {
                            field.set(entity, null);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            });
        }
        return (QueryWrapper)super.setEntity(entity);
    }

    protected QueryWrapper<T> addCondition(boolean condition, String column, SqlKeyword sqlKeyword, Object val) {
        if (ObjectUtil.isEmpty((Object)val)) {
            condition = false;
        }
        return (QueryWrapper)super.addCondition(condition, (Object)column, sqlKeyword, val);
    }
}

