/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.mybatis.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.dtyunxi.huieryun.dao.mybatis.support.datasource.MonitorProperties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="druid.monitor", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={MonitorProperties.class})
public class SqlMonitorAutoConfiguration {
    @Bean
    public ServletRegistrationBean<Servlet> registrationBean(MonitorProperties monitorProperties) {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{monitorProperties.getPath()});
        if (StrUtil.isNotBlank((CharSequence)monitorProperties.getAllow())) {
            bean.addInitParameter("allow", monitorProperties.getAllow());
        }
        if (StrUtil.isNotBlank((CharSequence)monitorProperties.getDeny())) {
            bean.addInitParameter("allow", monitorProperties.getDeny());
        }
        bean.addInitParameter("loginUsername", monitorProperties.getUsername());
        bean.addInitParameter("loginPassword", monitorProperties.getPassword());
        bean.addInitParameter("resetEnable", String.valueOf(monitorProperties.isResetEnable()));
        return bean;
    }

    @Bean
    public FilterRegistrationBean<Filter> druidStatFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        bean.addUrlPatterns(new String[]{"/*"});
        bean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return bean;
    }
}

