/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DataLimitContext {
    private static final ThreadLocal<Map<String, List<String>>> dataLimitRuleMap = new ThreadLocal();

    public static void addLimitRule(String tableName, List<String> subQueryList) {
        Map<String, List<String>> ruleMap = dataLimitRuleMap.get();
        if (ruleMap == null) {
            ruleMap = new HashMap<String, List<String>>();
        }
        ruleMap.putIfAbsent(tableName, subQueryList);
        dataLimitRuleMap.set(ruleMap);
    }

    public static List<String> getLimitRule(String tableName) {
        Map<String, List<String>> ruleMap = dataLimitRuleMap.get();
        if (CollectionUtils.isEmpty(ruleMap)) {
            return null;
        }
        List<String> rule = ruleMap.get(tableName);
        return rule;
    }

    public static void clear() {
        dataLimitRuleMap.remove();
    }
}

