/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds;

import com.baomidou.mybatisplus.core.metadata.CustomTableInfo;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.dtyunxi.eo.BaseEo;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseEoUtil {
    private static Logger logger = LoggerFactory.getLogger(BaseEoUtil.class);
    private static final Map<String, CustomTableInfo> tables = new ConcurrentHashMap<String, CustomTableInfo>();

    public static <T extends BaseEo> String tableName(Class<T> aClass) {
        return tables.get(aClass.getName()).getTableName();
    }

    public static <T extends BaseEo> CustomTableInfo tableInfo(Class<T> aClass) {
        return tables.get(aClass.getName());
    }

    public static <T extends BaseEo> CustomTableInfo tableInfo(String className) {
        return tables.get(className);
    }

    public static <T extends BaseEo> List<Field> getAllFields(Class<T> aClass) {
        return TableInfoHelper.getTableInfo(aClass).getFieldList().parallelStream().map(TableFieldInfo::getField).collect(Collectors.toList());
    }

    public static <T extends BaseEo> String idName(Class<T> aClass) {
        return tables.get(aClass.getName()).getIdColumn();
    }

    public static void addCustomTableInfo(String className, CustomTableInfo customTableInfo) {
        tables.put(className, customTableInfo);
    }
}

