/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.plugin;

import com.baomidou.mybatisplus.core.metadata.CustomTableInfo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import com.dtyunxi.huieryun.plugin.MyResultSetHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.util.ReflectionUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="parameterize", args={Statement.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ParameterInterceptor
implements Interceptor {
    private static Boolean META_EXT_ENABLED = Boolean.FALSE;
    private static final List<String> ignoresFields = Arrays.asList("extWhere", "orderBy", "orderByDesc", "sqlOrderBys", "extFields", "sqlFilters", "class");
    private static final String objList = "objList";

    private boolean isEnabled() {
        if (META_EXT_ENABLED == null) {
            String str = System.getProperty("cube.meta.ext.enabled");
            META_EXT_ENABLED = StringUtils.isBlank((CharSequence)str) || Boolean.parseBoolean(str);
        }
        return META_EXT_ENABLED;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.isEnabled()) {
            Object target = invocation.getTarget();
            if (target instanceof StatementHandler) {
                ParameterInterceptor.handleParams((StatementHandler)target);
            } else if (target instanceof ResultSetHandler) {
                return ParameterInterceptor.handleResult((Statement)invocation.getArgs()[0], target);
            }
        }
        return invocation.proceed();
    }

    private static List<Object> handleResult(Statement statement, Object target) throws NoSuchFieldException, IllegalAccessException, SQLException {
        Executor executor = (Executor)ParameterInterceptor.getFieldValue("executor", target);
        MappedStatement mappedStatement = (MappedStatement)ParameterInterceptor.getFieldValue("mappedStatement", target);
        ParameterHandler parameterHandler = (ParameterHandler)ParameterInterceptor.getFieldValue("parameterHandler", target);
        ResultSetHandler resultHandler = (ResultSetHandler)ParameterInterceptor.getFieldValue("resultHandler", target);
        BoundSql boundSql = (BoundSql)ParameterInterceptor.getFieldValue("boundSql", target);
        RowBounds rowBounds = (RowBounds)ParameterInterceptor.getFieldValue("rowBounds", target);
        Configuration configuration = (Configuration)ParameterInterceptor.getFieldValue("configuration", target);
        MyResultSetHandler myResultSethandler = new MyResultSetHandler(executor, mappedStatement, parameterHandler, (ResultHandler)resultHandler, boundSql, rowBounds);
        return myResultSethandler.handleResultSets(statement);
    }

    private static void handleParams(StatementHandler statementHandler) {
        Map paramObjMap;
        BoundSql boundSql = statementHandler.getBoundSql();
        Object paramObj = boundSql.getParameterObject();
        if (paramObj instanceof BaseEo && ParameterInterceptor.isIncluded(paramObj.getClass().getCanonicalName())) {
            ((BaseEo)paramObj).getExtFields().forEach((arg_0, arg_1) -> ((BoundSql)boundSql).setAdditionalParameter(arg_0, arg_1));
        } else if (paramObj instanceof Map && (paramObjMap = (Map)paramObj).containsKey(objList) && paramObjMap.get(objList) instanceof List) {
            List valueObjList = (List)paramObjMap.get(objList);
            boolean shouldSet = false;
            CustomTableInfo customTableInfo = null;
            Map[] objListParams = new HashMap[valueObjList.size()];
            for (int i = 0; i < valueObjList.size(); ++i) {
                Object obj = valueObjList.get(i);
                if (!(obj instanceof BaseEo) || !ParameterInterceptor.isIncluded(paramObj.getClass().getCanonicalName())) continue;
                shouldSet = true;
                BaseEo baseEo = (BaseEo)obj;
                if (customTableInfo == null) {
                    customTableInfo = BaseEoUtil.tableInfo(baseEo.getClass());
                }
                objListParams[i] = baseEo.getExtFields();
                CustomTableInfo finalCustomTableInfo = customTableInfo;
                int finalI = i;
                ReflectionUtils.doWithFields(obj.getClass(), field -> {
                    Object propertyValue;
                    boolean accessible = field.isAccessible();
                    if (!accessible) {
                        field.setAccessible(true);
                    }
                    if ((propertyValue = field.get(obj)) == null) {
                        propertyValue = finalCustomTableInfo.getColumnInfo(field.getName()).getDefaultValue();
                    }
                    if (!accessible) {
                        field.setAccessible(false);
                    }
                    objListParams[finalI].put(field.getName(), propertyValue);
                }, field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && !ignoresFields.contains(field.getName()) && finalCustomTableInfo.getColumnInfo(field.getName()) != null);
            }
            if (shouldSet) {
                boundSql.setAdditionalParameter(objList, (Object)objListParams);
            }
        }
    }

    private static boolean isIncluded(String clazzName) {
        return !"com.dtyunxi.yundt.cube.center.meta.dao.eo.AttributeEo".equals(clazzName) && !"com.dtyunxi.yundt.cube.center.meta.dao.eo.EntityEo".equals(clazzName);
    }

    private static Object getFieldValue(String fieldName, Object bean) throws NoSuchFieldException, IllegalAccessException {
        if (StringUtils.isEmpty((CharSequence)fieldName) || null == bean) {
            return null;
        }
        Field field = bean.getClass().getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(bean);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

