/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.plugin;

import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class QueryLimitInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(QueryLimitInterceptor.class);
    private static String APPEND_LIMIT_FRAGMENT;
    private static Boolean DO_APPEND_LIMIT_FRAGMENT;

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.bQueryLimit()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        String statementId = mappedStatement.getId();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        switch (sqlCommandType) {
            case SELECT: {
                this.interceptSelect(metaObject, boundSql, statementId);
                break;
            }
            case UPDATE: {
                this.interceptUpdate(boundSql, statementId);
            }
        }
        return invocation.proceed();
    }

    private void interceptSelect(MetaObject metaObject, BoundSql boundSql, String statementId) {
        boolean bLimit;
        String originSql = boundSql.getSql();
        String sql = originSql.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        boolean bl = bLimit = sql.toUpperCase().contains(" LIMIT ") || this.hIdCondition(sql) || this.hCount(sql) || sql.contains(";") || this.hadCodeCondition(sql);
        if (bLimit) {
            return;
        }
        metaObject.setValue("delegate.boundSql.sql", (Object)(originSql + this.readAppendFragment()));
        logger.warn("{} :: select without LIMIT!! auto append '{}' ", new Object[]{StringUtils.defaultString((String)statementId, (String)"--"), this.readAppendFragment(), new Exception("")});
    }

    private boolean hadCodeCondition(String sql) {
        return sql.contains(" code =") || sql.contains(" code=") || sql.contains("_code =") || sql.contains("_code=");
    }

    private String readAppendFragment() {
        if (StringUtils.isBlank((CharSequence)APPEND_LIMIT_FRAGMENT)) {
            String str = System.getProperty("dtyunxi.cube.mybatis.query.limit.count");
            int limitCount = StringUtils.isNumeric((CharSequence)str) ? Integer.parseInt(str) : 1000;
            APPEND_LIMIT_FRAGMENT = " LIMIT " + limitCount + " OFFSET 0 ";
        }
        return APPEND_LIMIT_FRAGMENT;
    }

    private boolean hCount(String sql) {
        return sql.toUpperCase().contains(" COUNT(");
    }

    private void interceptUpdate(BoundSql boundSql, String statementId) {
        boolean hIdCondition = this.hIdCondition(boundSql.getSql());
        if (hIdCondition) {
            return;
        }
        logger.warn(statementId + " Update without ID condition! ");
    }

    private boolean hIdCondition(String sql) {
        return sql.contains(" id ") || sql.contains(" id=") || sql.contains("(id=");
    }

    private boolean bQueryLimit() {
        if (DO_APPEND_LIMIT_FRAGMENT == null) {
            String str = System.getProperty("dtyunxi.cube.mybatis.query.limit.enabled");
            DO_APPEND_LIMIT_FRAGMENT = StringUtils.isBlank((CharSequence)str) || Boolean.parseBoolean(str);
        }
        return DO_APPEND_LIMIT_FRAGMENT;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    static {
        DO_APPEND_LIMIT_FRAGMENT = null;
    }
}

