/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasubscribe.provider.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.dtyunxi.huieryun.datasubscribe.provider.canal.CanalConfig;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CanalClient {
    private static final Logger logger = LoggerFactory.getLogger(CanalClient.class);
    private CanalConfig canalConfig;

    public CanalConnector getConnector() {
        final CanalConnector connector = this.canalConfig.getConnector();
        Callable<Boolean> yourTask = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    connector.connect();
                }
                catch (CanalClientException e) {
                    logger.warn("Canal Server connetion exception. Try again a second later.");
                    throw new CanalClientException((Throwable)e);
                }
                return true;
            }
        };
        Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(Predicates.isNull()).retryIfExceptionOfType(CanalClientException.class).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).build();
        try {
            retryer.call((Callable)yourTask);
        }
        catch (RetryException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.canalConfig.getTableFilterRegex()})) {
            connector.subscribe(this.canalConfig.getTableFilterRegex());
        } else {
            connector.subscribe();
        }
        return connector;
    }

    public CanalConfig getCanalConfig() {
        return this.canalConfig;
    }

    @ConstructorProperties(value={"canalConfig"})
    public CanalClient(CanalConfig canalConfig) {
        this.canalConfig = canalConfig;
    }
}

