/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class JacksonUtil {
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readValue(String jsonStr, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,Class<T>)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,TypeReference<T>)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static <T> T readValue(String jsonStr, Class<?> parametrized, Class<?> ... parameterClasses) {
        JavaType type = objectMapper.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
        try {
            return (T)objectMapper.readValue(jsonStr, type);
        }
        catch (IOException e) {
            throw new BusinessRuntimeException("JacksonUtil.readValue(String,Class<?>,Class...)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static String toJSon(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.toJSon\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static String toJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.toJSon\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public static Map<String, Object> toMap(String jsonStr) {
        try {
            return (Map)objectMapper.readValue(jsonStr, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("JacksonUtil.toMap(String)\u6267\u884c\u5f02\u5e38", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

