/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.identity.auth.api;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class CallerPermission {
    private Logger log = LoggerFactory.getLogger(CallerPermission.class);
    private Set<String> includePath;
    private Set<String> excludePath;
    private String secretKey;
    private static AntPathMatcher matcher = new AntPathMatcher();

    boolean doAuth(String path, String apiKey) {
        boolean exclude = this.doExcludeAuth(path);
        if (!exclude) {
            return exclude;
        }
        return this.doInclude(path, apiKey);
    }

    private boolean doInclude(String path, String apiKey) {
        boolean include = false;
        if (CollectionUtils.isEmpty(this.includePath)) {
            this.log.info("\u5f53\u524d\u63a5\u53e3\u4f7f\u7528\u8005:{} , \u672a\u914d\u7f6e\u4efb\u4f55\u53ef\u8c03\u7528\u63a5\u53e3.\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e", (Object)apiKey);
            return include;
        }
        for (String pattern : this.includePath) {
            if (!matcher.match(pattern, path)) continue;
            include = true;
            break;
        }
        return include;
    }

    private boolean doExcludeAuth(String path) {
        boolean exclude = true;
        if (CollectionUtils.isEmpty(this.excludePath)) {
            this.log.debug("\u672a\u914d\u7f6e\u7981\u7528\u63a5\u53e3,\u6821\u9a8c\u901a\u8fc7");
            return exclude;
        }
        for (String pattern : this.excludePath) {
            if (!matcher.match(pattern, path)) continue;
            exclude = false;
            this.log.debug("\u5b58\u5728\u7981\u7528\u63a5\u53e3:{},\u6821\u9a8c\u5931\u8d25.\u5f53\u524d\u8c03\u7528{}\u4e0d\u5408\u6cd5", (Object)pattern, (Object)path);
            break;
        }
        return exclude;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setIncludePath(Set<String> includePath) {
        this.includePath = includePath;
    }

    public void setIncludePath(String ... paths) {
        if (null == paths) {
            return;
        }
        HashSet<String> set = new HashSet<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            set.add(paths[i]);
        }
        this.includePath = set;
    }

    public void setExcludePath(String ... paths) {
        if (null == paths) {
            return;
        }
        HashSet<String> set = new HashSet<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            set.add(paths[i]);
        }
        this.excludePath = set;
    }

    public void setExcludePath(Set<String> excludePath) {
        this.excludePath = excludePath;
    }

    public String calculateSign(Map<String, Object> params, String charset) throws UnsupportedEncodingException {
        LinkedList<BasicNameValuePair> temp = new LinkedList<BasicNameValuePair>();
        for (String key : params.keySet()) {
            temp.add(new BasicNameValuePair(key, (String)params.get(key)));
        }
        temp.add(new BasicNameValuePair("secretKey", this.secretKey));
        String toDigest = URLEncodedUtils.format(temp, (String)charset);
        return DigestUtils.md5Hex((byte[])toDigest.getBytes(charset)).toUpperCase();
    }
}

