/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.resolver.AbstractEtcdNameResolver;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.ResolvedServerInfo;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DnsSrvNameResolver
extends AbstractEtcdNameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsSrvNameResolver.class);
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();
    private final String name;

    public DnsSrvNameResolver(String name, SharedResourceHolder.Resource<ExecutorService> executorResource) {
        super(name, executorResource);
        this.name = name;
    }

    @Override
    protected List<ResolvedServerInfo> getServers() {
        try {
            InitialDirContext ctx = new InitialDirContext(ENV);
            NamingEnumeration<?> resolved = ctx.getAttributes(this.name, ATTRIBUTE_IDS).get("srv").getAll();
            LinkedList<ResolvedServerInfo> servers = new LinkedList<ResolvedServerInfo>();
            while (resolved.hasMore()) {
                servers.add(this.srvRecordToServerInfo((String)resolved.next()));
            }
            return servers;
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @VisibleForTesting
    protected String getName() {
        return this.name;
    }

    private InetSocketAddress srvRecordToAddress(String dnsSrvRecord) {
        String[] split = dnsSrvRecord.split(" ");
        return new InetSocketAddress(split[3].trim(), Integer.parseInt(split[2].trim()));
    }

    private ResolvedServerInfo srvRecordToServerInfo(String dnsSrvRecord) {
        return new ResolvedServerInfo((SocketAddress)this.srvRecordToAddress(dnsSrvRecord), Attributes.EMPTY);
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

