/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.liquibase;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.liquibase.config.SpringLiquibaseConfiguration;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration.class})
@PropertySource(value={"classpath:config/liquibase.properties"})
public class LiquibaseAutoConfiguration {
    @Value(value="${bundle.liquibase.useNewDataSource: true}")
    private boolean useNewDataSource = true;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"bundle.liquibase.enable"}, havingValue="true")
    public SpringLiquibaseConfiguration springLiquibaseConfiguration(@Autowired(required=false) ObjectProvider<DataSourceVo> dataSourceVoObjectProvider, ObjectProvider<DataSource> dataSource) {
        DataSourceVo dataSourceVo = (DataSourceVo)dataSourceVoObjectProvider.getIfAvailable();
        if (this.useNewDataSource && dataSourceVo != null && StrUtil.isNotBlank((CharSequence)dataSourceVo.getJdbcUrl())) {
            return new SpringLiquibaseConfiguration(dataSourceVo);
        }
        return new SpringLiquibaseConfiguration((DataSource)dataSource.getIfAvailable());
    }

    @Bean
    @ConditionalOnProperty(value={"bundle.liquibase.enable"}, havingValue="true")
    public SpringLiquibase liquibase(SpringLiquibaseConfiguration springLiquibaseConfiguration) {
        return springLiquibaseConfiguration.createSpringLiquibase();
    }
}

