/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.liquibase.liquibase;

import com.dtyunxi.huieryun.liquibase.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.huieryun.liquibase.reader.AbstractBundleReader;
import com.dtyunxi.huieryun.liquibase.reader.LiquibaseBaseReader;
import com.dtyunxi.huieryun.liquibase.utils.MapUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleLiquibase
extends Liquibase {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BundleLiquibase.class);
    public static final char DIR_SEPERATOR_CHAR = '/';
    public static final String DIR_SEPERATOR = String.valueOf('/');
    public static final String FILE_SEPERATOR = "-";
    public static final String LIQUIBASE_DIR = "db/changelog";
    public static final String SQL_DIR = "db/changelog/sql";
    public static final String JAR_FILE_TAG = ".jar!/";
    public static final String BOOT_INF = "BOOT-INF";
    public static final String JAR_PATH_FILE_TAG = "!/BOOT-INF/";
    public static final String BOOT_INF_SQL_DIR = "BOOT-INF/classes/db/changelog/sql";
    public static Pattern VERSION_PATTERN = Pattern.compile("[0-9]+(.[0-9]+)+");

    public BundleLiquibase(String changeLogFile, ResourceAccessor resourceAccessor, DatabaseConnection conn) throws LiquibaseException {
        super(changeLogFile, resourceAccessor, conn);
    }

    public BundleLiquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database database) {
        super(changeLogFile, resourceAccessor, database);
    }

    public BundleLiquibase(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Database database) {
        super(changeLog, resourceAccessor, database);
    }

    public DatabaseChangeLog getDatabaseChangeLog() throws LiquibaseException {
        LOGGER.info("\u6536\u96c6DatabaseChangeLog");
        Map<String, List<String>> dependenceMap = this.collectBundleDependenceChain();
        LOGGER.info("\u4f9d\u8d56\u94fe\uff1a{}", dependenceMap);
        DatabaseChangeLog databaseChangeLog = super.getDatabaseChangeLog();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> sqlDir = classLoader.getResources(SQL_DIR);
            LOGGER.info("\u662f\u5426\u6709\u6587\u4ef6\uff1a{}", (Object)sqlDir.hasMoreElements());
            HashMap waitMap = Maps.newHashMap();
            TreeMap<String, URL> sqlDirMap = new TreeMap<String, URL>();
            while (sqlDir.hasMoreElements()) {
                URL url2 = sqlDir.nextElement();
                sqlDirMap.put(url2.getPath(), url2);
            }
            sqlDirMap.forEach((key, url) -> {
                LOGGER.info("\u5f53\u524d\u76ee\u5f55\uff1a{}", (Object)url.getPath());
                String bundleKey = this.resolveBundleKey((URL)url);
                if (bundleKey.startsWith("yundt-cube-center") || CollectionUtils.isEmpty((Collection)((Collection)dependenceMap.get(bundleKey)))) {
                    this.appendScript2ChangeLog(databaseChangeLog, (URL)url, dependenceMap, bundleKey);
                } else {
                    waitMap.put(bundleKey, url);
                }
            });
            BundleLiquibase.filterDependedNotInWaitMap(dependenceMap, waitMap);
            this.processWaitingMap(dependenceMap, waitMap, databaseChangeLog);
            databaseChangeLog.getChangeSets().stream().forEach(changeSet -> {
                LOGGER.info("changeSet\u96c6\u5408:{}", (Object)changeSet.getFilePath());
                changeSet.getChanges().stream().forEach(change -> {
                    SQLFileChange sqlFileChange = (SQLFileChange)change;
                    LOGGER.info("- - change\u96c6\u5408:{}", (Object)sqlFileChange.getPath());
                });
            });
        }
        catch (IOException e) {
            LOGGER.warn("\u8bfb\u53d6liquibase\u811a\u672c\u8d44\u6e90\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return databaseChangeLog;
    }

    public static void filterDependedNotInWaitMap(Map<String, List<String>> dependenceMap, Map<String, URL> waitMap) {
        dependenceMap.values().forEach(list -> {
            int i = 0;
            while (i < list.size()) {
                String depended = (String)list.get(i);
                if (waitMap.containsKey(depended)) {
                    ++i;
                    continue;
                }
                list.remove(i);
            }
        });
    }

    private void processWaitingMap(Map<String, List<String>> dependenceMap, Map<String, URL> waitMap, DatabaseChangeLog databaseChangeLog) {
        if (waitMap.isEmpty()) {
            return;
        }
        LOGGER.info("\u7b49\u5f85\u96c6\uff1a{}", waitMap);
        HashMap newWaitMap = Maps.newHashMap();
        waitMap.forEach((bundleKey, url) -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)dependenceMap.get(bundleKey)))) {
                this.appendScript2ChangeLog(databaseChangeLog, (URL)url, dependenceMap, (String)bundleKey);
            } else if (waitMap.containsKey(bundleKey)) {
                if (bundleKey.startsWith("yundt-cube-center")) {
                    this.appendScript2ChangeLog(databaseChangeLog, (URL)url, dependenceMap, (String)bundleKey);
                } else {
                    newWaitMap.put(bundleKey, url);
                }
            }
        });
        this.processWaitingMap(dependenceMap, newWaitMap, databaseChangeLog);
    }

    public static JarFile getJar(URL url) throws IOException {
        String jarPath = url.toString().substring(0, url.toString().lastIndexOf("!/") + 2);
        LOGGER.info("JAR\u8def\u5f84\uff1a{}", (Object)jarPath);
        URL jarURL = new URL(jarPath);
        JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
        JarFile jarFile = jarCon.getJarFile();
        return jarFile;
    }

    private void appendScript2ChangeLog(DatabaseChangeLog databaseChangeLog, URL url, Map<String, List<String>> dependenceMap, String bundleKey) {
        try {
            String path = url.getPath();
            if (path.indexOf(JAR_FILE_TAG) != -1) {
                JarFile jarFile = BundleLiquibase.getJar(url);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                TreeMap<String, JarEntry> treeMap = new TreeMap<String, JarEntry>();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry2 = enumeration.nextElement();
                    treeMap.put(jarEntry2.getName(), jarEntry2);
                }
                treeMap.forEach((key, jarEntry) -> {
                    if (jarEntry.getName().startsWith(SQL_DIR)) {
                        if (jarEntry.isDirectory()) {
                            LOGGER.info("jar\u5305\u5185\u76ee\u5f55\uff1a{}", (Object)jarEntry.getName());
                        } else {
                            LOGGER.info("\u76f4\u63a5\u8def\u5f84\u4e0b\uff1a{}", (Object)jarEntry.getName());
                            this.appendChangeLog(databaseChangeLog, BundleLiquibase.getDirPreFix(jarEntry.getName()), this.getChangeLogParameters(), jarEntry.getName().replace(SQL_DIR, ""));
                        }
                    } else if (jarEntry.getName().startsWith(BOOT_INF_SQL_DIR)) {
                        if (jarEntry.isDirectory()) {
                            LOGGER.info("jar\u5305\u5185\u76ee\u5f55\uff1a{}", (Object)jarEntry.getName());
                        } else {
                            LOGGER.info("BOOT-INF/classes/\u8def\u5f84\u4e0b\uff1a{}", (Object)jarEntry.getName());
                            this.appendChangeLog(databaseChangeLog, BundleLiquibase.getDirPreFix(jarEntry.getName()), this.getChangeLogParameters(), jarEntry.getName().replace(BOOT_INF_SQL_DIR, ""));
                        }
                    }
                });
            } else {
                File dir = new File(url.toURI());
                if (dir.exists() && dir.isDirectory()) {
                    this.recurseSysFile(databaseChangeLog, bundleKey, dir);
                }
            }
            dependenceMap.values().forEach(list -> list.remove(bundleKey));
        }
        catch (Exception e) {
            LOGGER.warn("\u8bfb\u53d6URL\u5f02\u5e382\uff1a", (Throwable)e);
        }
    }

    private static String getDirPreFix(String jarName) {
        String[] dirPaths = jarName.replace("\\", DIR_SEPERATOR).split(DIR_SEPERATOR);
        StringBuilder dirPrefix = new StringBuilder();
        for (int i = 3; i < dirPaths.length - 1; ++i) {
            dirPrefix.append(dirPaths[i]).append(FILE_SEPERATOR);
        }
        LOGGER.info("sql\u811a\u672c\u76f8\u5bf9\u8def\u5f84\u524d\u7f00\uff1a{}", (Object)dirPrefix);
        if (dirPrefix.length() == 0) {
            return "";
        }
        return dirPrefix.deleteCharAt(dirPrefix.length() - 1).toString();
    }

    private void recurseSysFile(DatabaseChangeLog databaseChangeLog, String bundleKey, File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                LOGGER.info("\u76ee\u5f55\uff1a{}", (Object)file.getPath());
                this.recurseSysFile(databaseChangeLog, bundleKey, file);
                continue;
            }
            LOGGER.info("\u5f53\u524dsql\u6587\u4ef6\uff1a{}", (Object)file.getName());
            String[] dirPathItems = dir.getPath().replace("\\", DIR_SEPERATOR).split(SQL_DIR + DIR_SEPERATOR);
            if (dirPathItems == null || dirPathItems.length < 2) continue;
            this.appendChangeLog(databaseChangeLog, dirPathItems[1].replace(DIR_SEPERATOR, FILE_SEPERATOR), this.getChangeLogParameters(), dirPathItems[1] + DIR_SEPERATOR + file.getName());
        }
    }

    private String resolveBundleKey(URL url) {
        String[] urlPathItems = url.getPath().split(DIR_SEPERATOR);
        String bundleKey = "";
        if (url.getPath().indexOf(JAR_FILE_TAG) != -1) {
            bundleKey = BundleLiquibase.collecteBundleKey(url.getPath());
        } else {
            for (int i = 0; i < urlPathItems.length; ++i) {
                if (!"target".equals(urlPathItems[i])) continue;
                bundleKey = AbstractBundleReader.removeAfterFix(urlPathItems[i - 1]);
                break;
            }
        }
        return bundleKey;
    }

    private static String collecteBundleKey(String path) {
        String bundleKey = "";
        int lastIndex = path.lastIndexOf(JAR_FILE_TAG);
        if (lastIndex != -1) {
            LinkedList<Character> characters = new LinkedList<Character>();
            StringBuilder sb = new StringBuilder();
            char[] chs = path.toCharArray();
            for (int i = lastIndex - 1; i > 0 && chs[i] != '/'; --i) {
                characters.addFirst(Character.valueOf(chs[i]));
            }
            Iterator i = characters.iterator();
            while (i.hasNext()) {
                char ch = ((Character)i.next()).charValue();
                sb.append(ch);
            }
            bundleKey = sb.toString();
            StringBuilder finalBundleKey = new StringBuilder();
            for (String item : bundleKey.split(FILE_SEPERATOR)) {
                if (VERSION_PATTERN.matcher(item).matches()) break;
                finalBundleKey.append(item).append(FILE_SEPERATOR);
            }
            bundleKey = AbstractBundleReader.removeAfterFix(finalBundleKey.deleteCharAt(finalBundleKey.length() - 1).toString());
        }
        return bundleKey;
    }

    private Map<String, List<String>> collectBundleDependenceChain() {
        Map<String, BundleBaseSettingRespDto> artifactMap = new LiquibaseBaseReader().process(false);
        HashMap dependenceMap = Maps.newHashMap();
        artifactMap.forEach((key, value) -> {
            if (value.getBase() != null && CollectionUtils.isNotEmpty(value.getBase().getDependencies())) {
                String sourceBundleKey = AbstractBundleReader.removeAfterFix(value.getArtifactId());
                value.getBase().getDependencies().forEach(bundleBaseDto -> {
                    String targetBundleKey = AbstractBundleReader.removeAfterFix(bundleBaseDto.getArtifactId());
                    if (!targetBundleKey.equals(sourceBundleKey)) {
                        MapUtils.appendUnique2ListMap(sourceBundleKey, dependenceMap, targetBundleKey);
                    }
                });
            }
        });
        return dependenceMap;
    }

    private void appendChangeLog(DatabaseChangeLog databaseChangeLog, String id, ChangeLogParameters changeLogParameters, String fileName) {
        if (!fileName.endsWith(".sql") && !fileName.endsWith(".procedure")) {
            return;
        }
        if (fileName.startsWith(DIR_SEPERATOR)) {
            fileName = fileName.substring(1);
        }
        DatabaseChangeLog curDatabaseChangeLog = new DatabaseChangeLog();
        curDatabaseChangeLog.setRootChangeLog(databaseChangeLog);
        curDatabaseChangeLog.setPhysicalFilePath(String.format("%s%sdb.changelog-%s.yaml", LIQUIBASE_DIR, DIR_SEPERATOR, id));
        curDatabaseChangeLog.setContexts(databaseChangeLog.getContexts());
        curDatabaseChangeLog.setChangeLogParameters(changeLogParameters);
        ChangeSet changeSet = new ChangeSet(String.format("%s-%s", id, fileName.replace(".sql", "")), "bundle-insert", false, false, curDatabaseChangeLog.getPhysicalFilePath(), null, null, curDatabaseChangeLog);
        changeSet.setChangeLogParameters(changeLogParameters);
        changeSet.addChange((Change)this.createSQLFileChange("mysql", "utf-8", String.format("sql%s%s", DIR_SEPERATOR, fileName), true));
        databaseChangeLog.addChangeSet(changeSet);
    }

    public SQLFileChange createSQLFileChange(String dbms, String encoding, String path, Boolean relativeToChangelogFile) {
        SQLFileChange sqlFileChange = new SQLFileChange();
        sqlFileChange.setEncoding(encoding);
        sqlFileChange.setDbms(dbms);
        sqlFileChange.setPath(path);
        if (path.endsWith(".procedure")) {
            sqlFileChange.setEndDelimiter("//");
        }
        sqlFileChange.setRelativeToChangelogFile(relativeToChangelogFile);
        sqlFileChange.setResourceAccessor(this.getResourceAccessor());
        return sqlFileChange;
    }
}

