/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.localcache.api;

import com.dtyunxi.huieryun.localcache.api.AbstractLocalCacheService;
import com.dtyunxi.huieryun.localcache.api.ILocalCacheService;
import com.dtyunxi.huieryun.localcache.constants.LocalCacheTypeEnum;
import com.dtyunxi.huieryun.localcache.vo.LocalCacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFactory {
    private static final Logger log = LoggerFactory.getLogger(LocalCacheFactory.class);

    public static final ILocalCacheService createCache(String group, LocalCacheRegistryVo cacheRegistryVo) {
        LocalCacheTypeEnum type;
        if (log.isDebugEnabled()) {
            log.debug("group={},cacheRegistryVo={}", (Object)group, (Object)cacheRegistryVo);
        }
        if ((type = LocalCacheTypeEnum.getByName(cacheRegistryVo.getType())) == null) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9aCacheService\u7c7b\u578b");
        }
        String className = null;
        switch (type) {
            case CAFFEINE: {
                className = "com.dtyunxi.huieryun.localcache.impl.caffeine.CaffeineCacheServiceImpl";
                break;
            }
            case EHCACHE: {
                className = "com.dtyunxi.huieryun.localcache.impl.ehcache.EhcacheCacheServiceImpl";
                break;
            }
            case GUAVA: {
                className = "com.dtyunxi.huieryun.localcache.impl.guava.GuavaCacheServiceImpl";
            }
        }
        try {
            AbstractLocalCacheService cacheService = (AbstractLocalCacheService)Class.forName(className).newInstance();
            cacheService.init(group, cacheRegistryVo);
            return cacheService;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u91cd\u8bd5\u670d\u52a1\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u91cd\u8bd5\u670d\u52a1\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
    }
}

