/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.api;

import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.concurrent.TimeUnit;

public interface ILockService {
    public static final String LOCKSERVICE_ETCD = "etcd";
    public static final String LOCKSERVICE_REDIS = "redis";
    public static final int MAX_KEEP_TIMEOUT = 5;
    public static final int MAX_WAIT_TIMEOUT = 0;

    default public Mutex lock(String tableName, Long primaryKey) {
        return this.lock(tableName, String.valueOf(primaryKey), 0);
    }

    default public Mutex lock(String tableName, String primaryKey) {
        return this.lock(tableName, primaryKey, 0);
    }

    default public Mutex lock(String tableName, Long primaryKey, int waitTimeout) {
        return this.lock(tableName, String.valueOf(primaryKey), waitTimeout);
    }

    default public Mutex lock(String tableName, String primaryKey, int waitTimeout) {
        return this.lock(tableName, primaryKey, waitTimeout, 5, TimeUnit.SECONDS);
    }

    default public Mutex lock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        throw new BusinessRuntimeException("ETCD\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    default public Mutex readLock(String tableName, Long primaryKey) {
        return this.readLock(tableName, String.valueOf(primaryKey));
    }

    default public Mutex readLock(String tableName, String primaryKey) {
        return this.readLock(tableName, primaryKey, 0);
    }

    default public Mutex readLock(String tableName, Long primaryKey, int waitTimeout) {
        return this.readLock(tableName, primaryKey, waitTimeout);
    }

    default public Mutex readLock(String tableName, String primaryKey, int waitTimeout) {
        return this.readLock(tableName, primaryKey, waitTimeout, 5, TimeUnit.SECONDS);
    }

    default public Mutex readLock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public Mutex writeLock(String tableName, Long primaryKey) {
        return this.writeLock(tableName, String.valueOf(primaryKey));
    }

    default public Mutex writeLock(String tableName, String primaryKey) {
        return this.writeLock(tableName, primaryKey, 0);
    }

    default public Mutex writeLock(String tableName, Long primaryKey, int waitTimeout) {
        return this.writeLock(tableName, String.valueOf(primaryKey), waitTimeout);
    }

    default public Mutex writeLock(String tableName, String primaryKey, int waitTimeout) {
        return this.writeLock(tableName, primaryKey, waitTimeout, 5, TimeUnit.SECONDS);
    }

    default public Mutex writeLock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    public boolean unlock(Mutex var1);

    default public boolean unlockRead(Mutex mutex) {
        throw new BusinessRuntimeException("ETCD\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    default public boolean unlockWrite(Mutex mutex) {
        throw new BusinessRuntimeException("ETCD\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public boolean isLocked(String var1, Long var2);

    public boolean isLocked(String var1, String var2);

    default public String getLockAcquirer(String tableName, Long primaryKey) {
        throw new BusinessRuntimeException("Redisson\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    default public String getLockAcquirer(String tableName, String primaryKey) {
        throw new BusinessRuntimeException("Redisson\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    default public Mutex multiLock(String key, int[] bitmapIds) {
        throw new BusinessRuntimeException("ETCD\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    default public boolean unlockMulti(Mutex mutex, int[] bitmapIds) {
        throw new BusinessRuntimeException("ETCD\u7c7b\u578b\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public void shutdown();
}

