/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.api;

import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.vo.LockRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(LockServiceFactory.class);

    public static ILockService createLockService(LockRegistryVo lockVo) {
        return LockServiceFactory.createLockService(lockVo, null);
    }

    public static ILockService createLockService(LockRegistryVo lockVo, String profile) {
        logger.debug("Set lock provider as {}", (Object)lockVo);
        if (lockVo == null || lockVo.getEndpoints() == null) {
            throw new BusinessRuntimeException("Please registry lock service provider");
        }
        AbstractLockService lockService = null;
        if (lockVo.getProvider() == null) {
            logger.warn("Fallback to default lock service {} ", (Object)"redis");
            lockVo.setProvider("redis");
        }
        String className = null;
        switch (lockVo.getProvider().toLowerCase()) {
            case "etcd": {
                className = "com.dtyunxi.huieryun.lock.provider.etcd.EtcdLockService";
                break;
            }
            case "redis": {
                className = "com.dtyunxi.huieryun.lock.provider.redis.RedisLockService";
                break;
            }
        }
        try {
            lockService = (AbstractLockService)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u5206\u5e03\u5f0f\u9501\u5ba2\u6237\u7aef\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u5206\u5e03\u5f0f\u9501\u63d0\u5ba2\u6237\u7aef\u4f9b\u7c7b\uff1a" + className);
        }
        lockService.init(lockVo);
        lockService.initProfile(profile);
        return lockService;
    }
}

