/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.autoconfigure;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.LockServiceFactory;
import com.dtyunxi.huieryun.lock.vo.LockRegistryVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

public class LockAutoConfiguration {
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="huieryun.service.lock.lockregistryvo")
    public LockRegistryVo lockRegistryVo() {
        return new LockRegistryVo();
    }

    @Bean
    @ConditionalOnMissingBean
    public ILockService lockService(LockRegistryVo lockRegistryVo) {
        String pfile = StringUtils.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        return LockServiceFactory.createLockService(lockRegistryVo, pfile);
    }
}

