/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.provider.redis;

import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.enums.WorkModel;
import com.dtyunxi.huieryun.lock.vo.LockRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.RedissonConfigHelper;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class RedisLockService
extends AbstractLockService {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockService.class);
    private RedissonClient redisson;

    public void init(LockRegistryVo lockVo) {
        super.init(lockVo);
        WorkModel workModel = WorkModel.getWorkModelByName((String)lockVo.getWorkModel());
        if (workModel == null) {
            throw new IllegalArgumentException("\u5206\u5e03\u5f0f\u9501\u8bbe\u7f6e\u6a21\u5f0f\u9519\u8bef\uff01");
        }
        String configFilePath = "/config/redission-" + workModel.getName().toLowerCase() + "-server-config.yaml";
        Config config = this.getRedissonCustomConfigFromYamlFile(configFilePath);
        switch (workModel) {
            case SINGLE: {
                SingleServerConfig singleServerConfig = RedissonConfigHelper.getSingleServerConfig(config);
                singleServerConfig.setConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                singleServerConfig.setAddress(lockVo.getEndpoints()[0]);
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                singleServerConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case SENTINE: {
                SentinelServersConfig sentinelServersConfig = RedissonConfigHelper.getSentinelServersConfig(config);
                sentinelServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                sentinelServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                sentinelServersConfig.addSentinelAddress(lockVo.getEndpoints());
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                sentinelServersConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case CLUSTER: {
                ClusterServersConfig clusterServersConfig = RedissonConfigHelper.getClusterServersConfig(config);
                clusterServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                clusterServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                clusterServersConfig.addNodeAddress(lockVo.getEndpoints());
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                clusterServersConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case MASTERSLAVE: {
                MasterSlaveServersConfig masterSlaveServersConfig = RedissonConfigHelper.getMasterSlaveServersConfig(config);
                masterSlaveServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                masterSlaveServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                String master = lockVo.getEndpoints()[0];
                masterSlaveServersConfig.setMasterAddress(master);
                if (lockVo.getEndpoints().length > 1) {
                    String[] slaves = Arrays.copyOfRange(lockVo.getEndpoints(), 1, lockVo.getEndpoints().length);
                    masterSlaveServersConfig.addSlaveAddress(slaves);
                }
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                masterSlaveServersConfig.setPassword(lockVo.getPasswd());
                break;
            }
            case REPLICATED: {
                ReplicatedServersConfig replicatedServersConfig = RedissonConfigHelper.getReplicatedServersConfig(config);
                replicatedServersConfig.addNodeAddress(lockVo.getEndpoints());
                replicatedServersConfig.setMasterConnectionMinimumIdleSize(lockVo.getMasterConnectionMinimumIdleSize());
                replicatedServersConfig.setSlaveConnectionMinimumIdleSize(lockVo.getSlaveConnectionMinimumIdleSize());
                if (!StringUtils.isNotBlank((CharSequence)lockVo.getPasswd())) break;
                replicatedServersConfig.setPassword(lockVo.getPasswd());
            }
        }
        this.redisson = Redisson.create((Config)config);
    }

    protected Config getRedissonCustomConfigFromYamlFile(String configFilePath) {
        ClassPathResource fileResource = new ClassPathResource(configFilePath, RedisLockService.class.getClassLoader());
        try {
            return Config.fromYAML((InputStream)fileResource.getInputStream());
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6Redssion\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff01\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)configFilePath, (Object)e);
            throw new BusinessRuntimeException("\u8bfb\u53d6Redssion\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff01\u6587\u4ef6\u8def\u5f84\uff1a" + configFilePath, (Throwable)e);
        }
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        RLock rLock = this.getFairLock(tableName, primaryKey);
        return this.lock(rLock, waitTimeout, leaseTime, timeUnit);
    }

    public Mutex lock(RLock rLock, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        Mutex mutex = new Mutex(rLock.getName());
        boolean res = false;
        try {
            res = rLock.tryLock((long)waitTimeout, (long)leaseTime, timeUnit);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Throwable)e);
        }
        if (!res) {
            throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
        }
        return mutex;
    }

    public Mutex readLock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        return this.lock(this.getReadLock(tableName, primaryKey), waitTimeout, leaseTime, TimeUnit.SECONDS);
    }

    public Mutex writeLock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        return this.lock(this.getWriteLock(tableName, primaryKey), waitTimeout, leaseTime, TimeUnit.SECONDS);
    }

    private RLock getFairLock(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        return this.redisson.getFairLock(lockKey);
    }

    private RLock getReadLock(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        RReadWriteLock readWriteLock = this.redisson.getReadWriteLock(lockKey);
        return readWriteLock.readLock();
    }

    private RLock getWriteLock(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        RReadWriteLock readWriteLock = this.redisson.getReadWriteLock(lockKey);
        RLock rLock = readWriteLock.writeLock();
        return rLock;
    }

    public boolean unlock(Mutex mutex) {
        if (null == mutex) {
            return true;
        }
        try {
            RLock rLock = this.redisson.getFairLock(mutex.getLockKey());
            rLock.unlock();
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u9501\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean unlockRead(Mutex mutex) {
        if (null == mutex) {
            return true;
        }
        try {
            RReadWriteLock readWriteLock = this.redisson.getReadWriteLock(mutex.getLockKey());
            RLock rLock = readWriteLock.readLock();
            rLock.unlock();
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u9501\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean unlockWrite(Mutex mutex) {
        if (null == mutex) {
            return true;
        }
        try {
            RReadWriteLock readWriteLock = this.redisson.getReadWriteLock(mutex.getLockKey());
            RLock rLock = readWriteLock.writeLock();
            rLock.unlock();
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u9501\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean isLocked(String tableName, Long primaryKey) {
        return this.isLocked(tableName, String.valueOf(primaryKey));
    }

    public boolean isLocked(String tableName, String primaryKey) {
        RReadWriteLock readWriteLock;
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        RLock rLock = this.redisson.getFairLock(lockKey);
        boolean isLocked = rLock.isLocked();
        if (!isLocked && null != (readWriteLock = this.redisson.getReadWriteLock(lockKey))) {
            logger.debug("locked by readWriteLock");
            isLocked = readWriteLock.readLock().isLocked() || readWriteLock.readLock().isLocked();
        }
        return isLocked;
    }

    private String convert2String(RoaringBitmap rbp) {
        int roaringMapSize = rbp.serializedSizeInBytes();
        ByteBuffer buffer = ByteBuffer.allocate(roaringMapSize);
        rbp.serialize(buffer);
        byte[] bitmapData = buffer.array();
        String encodeString = Base64.getEncoder().encodeToString(bitmapData);
        logger.info("bitmapData size " + bitmapData.length);
        logger.info("encode len " + encodeString.length());
        return encodeString;
    }

    private RoaringBitmap parseBitmap(String encodedString) throws IOException {
        RoaringBitmap drr = new RoaringBitmap();
        if (encodedString != null) {
            byte[] decode = Base64.getDecoder().decode(encodedString);
            drr.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(decode)));
        }
        return drr;
    }

    private RBucket<String> getBucket(String key) {
        RBucket bucket = this.redisson.getBucket(key, (Codec)new StringCodec("utf-8"));
        return bucket;
    }

    public Mutex multiLock(String key, int[] bitmapIds) {
        String lockKey = Mutex.buildLockKey((String)key, (String)"multi");
        RBucket<String> bucket = this.getBucket(lockKey);
        String strCurrentBitmap = (String)bucket.get();
        try {
            RoaringBitmap lockBitmap = this.parseBitmap(strCurrentBitmap);
            RoaringBitmap tryBitmap = new RoaringBitmap();
            tryBitmap.add(bitmapIds);
            RoaringBitmap rr = RoaringBitmap.and((RoaringBitmap)tryBitmap, (RoaringBitmap)lockBitmap);
            long card = rr.getLongCardinality();
            if (card == 0L) {
                lockBitmap.or(tryBitmap);
                boolean setted = bucket.compareAndSet((Object)strCurrentBitmap, (Object)this.convert2String(lockBitmap));
                if (setted) {
                    return new Mutex(lockKey);
                }
            } else {
                logger.info("***card " + card);
            }
        }
        catch (IOException e) {
            throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Throwable)e);
        }
        throw new BusinessRuntimeException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
    }

    public boolean unlockMulti(Mutex mutex, int[] bitmapIds) {
        RBucket<String> bucket = this.getBucket(mutex.getLockKey());
        String strCurrentBitmap = (String)bucket.get();
        try {
            RoaringBitmap lockBitmap = this.parseBitmap(strCurrentBitmap);
            RoaringBitmap tryBitmap = new RoaringBitmap();
            tryBitmap.add(bitmapIds);
            lockBitmap.xor(tryBitmap);
            logger.info("***unlock" + lockBitmap.getLongCardinality());
            boolean setted = bucket.compareAndSet((Object)strCurrentBitmap, (Object)this.convert2String(lockBitmap));
            if (setted) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u9501\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
        return false;
    }

    public void shutdown() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    public String getLockAcquirer(String tableName, Long primaryKey) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public String getLockAcquirer(String tableName, String primaryKey) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }
}

