/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.filter;

import com.dtyunxi.app.ServiceContext;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.InvocationHandler;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.filter.ClientFilter;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSFConsumerContextFilter
implements ClientFilter {
    private static Logger logger = LoggerFactory.getLogger(HSFConsumerContextFilter.class);

    public ListenableFuture<RPCResult> invoke(InvocationHandler invocationHandler, Invocation invocation) throws Throwable {
        Map contextMap = ServiceContext.getContext().getAttachments();
        try {
            if (contextMap != null && contextMap.size() > 0) {
                for (String key : contextMap.keySet()) {
                    ServiceContext.getContext().setAttachment(key, (String)contextMap.get(key));
                }
            }
        }
        catch (Exception e) {
            logger.error("ConsumerContextFilter invoke exception", (Throwable)e);
        }
        return invocationHandler.invoke(invocation);
    }

    public void onResponse(Invocation invocation, RPCResult rpcResult) {
        Map contextMap = ServiceContext.getContext().getKeys();
        try {
            if (contextMap != null && contextMap.size() > 0) {
                for (String key : contextMap.keySet()) {
                    ServiceContext.getContext().setAttachment(key, (String)contextMap.get(key));
                }
            }
        }
        catch (Exception e) {
            logger.error("ConsumerContextFilter onResponse exception", (Throwable)e);
        }
    }
}

