/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;

public abstract class AbstractApiLogAspect {
    private static Logger logger = LoggerFactory.getLogger(AbstractApiLogAspect.class);
    private static final String LEVEL_EMP = "empty";
    private static final String LEVEL_ADJ = "adjust";
    private static final String LEVEL_FULL = "full";
    private static final int ADJ_LEN = 4096;

    public abstract void apiLogAop();

    protected String getLogRespLevel() {
        return LEVEL_EMP;
    }

    protected int getAdjustLenth() {
        return 4096;
    }

    @Around(value="apiLogAop()")
    public Object aroundApi(ProceedingJoinPoint point) throws Throwable {
        return this.log(point);
    }

    private Object log(ProceedingJoinPoint point) throws Throwable {
        DateTime startTime = new DateTime();
        DateTime endTime = null;
        Interval interval = null;
        Object response = null;
        try {
            logger.info("Call API {}.{} Begin () Request => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs())});
            response = point.proceed();
        }
        catch (Exception e) {
            endTime = new DateTime();
            interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            logger.error("Call API {}.{} End () Request => {}, RT:{} ms, Error => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), e.getMessage()});
            logger.error("", (Throwable)e);
            throw e;
        }
        endTime = new DateTime();
        interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
        if (logger.isDebugEnabled()) {
            logger.debug("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), this.argsToString(response)});
        }
        try {
            if (LEVEL_FULL.equals(this.getLogRespLevel())) {
                logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), this.argsToString(response)});
            } else if (LEVEL_ADJ.equals(this.getLogRespLevel())) {
                RestResponse restResponse = (RestResponse)response;
                logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), this.argsToAdjustString(restResponse)});
            } else {
                RestResponse restResponse = (RestResponse)response;
                logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), this.argsToString(restResponse)});
            }
        }
        catch (Exception e) {
            logger.error("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), this.argsToString(point.getArgs()), interval.toDurationMillis(), this.argsToString(response)});
        }
        return response;
    }

    private String argsToString(Object object) {
        try {
            return JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            logger.error("JSON \u8f6c\u6362\u51fa\u9519\uff0c\u54cd\u5e94\u4fe1\u606f\u4e0d\u660e", (Throwable)e);
            return "JSON \u8f6c\u6362\u51fa\u9519\uff0c\u54cd\u5e94\u4fe1\u606f\u4e0d\u660e";
        }
    }

    private String argsToString(RestResponse<?> restResponse) {
        return "{\"reultCode\":" + restResponse.getResultCode() + ",\"resultMsg\":\"" + restResponse.getResultMsg() + "\"}";
    }

    private String argsToAdjustString(RestResponse<?> restResponse) {
        String data = JSON.toJSONString((Object)restResponse.getData());
        return "{\"reultCode\":" + restResponse.getResultCode() + ",\"resultMsg\":\"" + restResponse.getResultMsg() + "\", \"data\":\"" + data.substring(0, data.length() > this.getAdjustLenth() ? this.getAdjustLenth() : data.length()) + "\"}";
    }
}

