/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun.util;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.dtyunxi.huieryun.mq.constant.TunnelType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunConsumerHelper {
    private static Logger logger = LoggerFactory.getLogger(AliyunConsumerHelper.class);
    private static final ThreadLocal<String> LOCAL_MSG_ID = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<Message> LOCAL_MSG = new ThreadLocal<Message>(){

        @Override
        protected Message initialValue() {
            return null;
        }
    };

    public static String getMsgId() {
        return LOCAL_MSG_ID.get();
    }

    public static Message getMsgInfo() {
        return LOCAL_MSG.get();
    }

    public static void setMsgId(String msgId) {
        LOCAL_MSG_ID.set(msgId);
    }

    public static void setMsgfo(Message msg) {
        LOCAL_MSG.set(msg);
    }

    public static void clearThreadInfo() {
        LOCAL_MSG_ID.remove();
        LOCAL_MSG.remove();
    }

    public static Properties getProperties(MessageRegistryVo messageRegistryVo) {
        Properties properties = new Properties();
        properties.setProperty("AccessKey", messageRegistryVo.getUsername());
        properties.setProperty("SecretKey", messageRegistryVo.getPassword());
        if (TunnelType.SINGLE.getName().equals(messageRegistryVo.getTunnel())) {
            properties.setProperty("NAMESRV_ADDR", messageRegistryVo.getHost());
        } else if ("nameServer".equals(messageRegistryVo.getTunnel())) {
            properties.setProperty("NAMESRV_ADDR", messageRegistryVo.getHost());
        } else {
            properties.setProperty("ONSAddr", messageRegistryVo.getHost());
        }
        if (logger.isInfoEnabled()) {
            logger.info("aliyun mq properties:{}", (Object)JSON.toJSONString((Object)properties));
        }
        return properties;
    }
}

