/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit;

import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitMqManager;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.rabbitmq.client.ConnectionFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQHelper {
    private static Logger logger = LoggerFactory.getLogger(RabbitMQHelper.class);

    public static RabbitMqManager connectRabbitMqManager(MessageRegistryVo messageRegistryVo) {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            if (messageRegistryVo.getAddresses() == null) {
                connectionFactory.setHost(messageRegistryVo.getHost());
                connectionFactory.setPort(Integer.parseInt(messageRegistryVo.getPort()));
            }
            connectionFactory.setUsername(messageRegistryVo.getUsername());
            connectionFactory.setPassword(messageRegistryVo.getPassword());
            connectionFactory.setVirtualHost(messageRegistryVo.getVirtualHost());
            ExecutorService service = Executors.newFixedThreadPool(messageRegistryVo.getConsumeThreadNums());
            connectionFactory.setSharedExecutor(service);
            connectionFactory.setConnectionTimeout(30000);
            connectionFactory.setAutomaticRecoveryEnabled(true);
            connectionFactory.setTopologyRecoveryEnabled(true);
            connectionFactory.setNetworkRecoveryInterval(10000);
            connectionFactory.setRequestedHeartbeat(360);
            RabbitMqManager rabbitMqManager = new RabbitMqManager(connectionFactory, messageRegistryVo.getAddresses());
            rabbitMqManager.start();
            return rabbitMqManager;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaRabbitMQ\u6d88\u606f\u8fde\u63a5\u51fa\u9519: {}", (Object)messageRegistryVo);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }
}

