/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.rocket.assembler.MessageAssembler;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketConsumerFactory;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(RocketConsumer.class);
    private static volatile RocketConsumer single = null;
    private static final String CONSUMER_GROUP_FORMATER = "%s_%s_%s";

    private RocketConsumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketConsumer getInstance() {
        if (single != null) return single;
        Class<RocketConsumer> clazz = RocketConsumer.class;
        synchronized (RocketConsumer.class) {
            single = new RocketConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void createConsumer(MessageRegistryVo topicInfo) {
        this.messageRegistryVo = topicInfo;
    }

    public <T> MessageResponse receiveMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        logger.info("receiveMessage,topicName:{},routingKey:{}", (Object)topicName, (Object)routingKey);
        return this.receiveMessage(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor);
    }

    public <T> MessageResponse receiveMessage(String topic, String consumer, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topic, consumer, routingKey, processor, null);
    }

    public MessageResponse receiveMessage(String topicName, String consumer, Map<String, IMessageProcessor> processorMap) {
        try {
            for (Map.Entry<String, IMessageProcessor> entry : processorMap.entrySet()) {
                this.receiveMessage(topicName, consumer, entry.getKey(), entry.getValue());
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:{},consumer:{}", new Object[]{topicName, consumer, e});
            throw new BusinessRuntimeException("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:" + topicName + ",consumer:" + consumer, (Throwable)e);
        }
    }

    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor);
    }

    public <T> MessageResponse subscribe(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor) {
        logger.info("subscribe,topicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey});
        return this.toSubscribeMessage(topicName, consumer, routingKey, processor, MessageModel.CLUSTERING);
    }

    private <T> MessageResponse toSubscribeMessage(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor, MessageModel messageModel) {
        consumer = consumer != null ? consumer : this.messageRegistryVo.getConsumerId();
        String consumerGroup = null;
        consumerGroup = StringUtils.isNotBlank((CharSequence)routingKey) ? String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, routingKey) : String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, "ALL");
        try {
            DefaultMQPushConsumer defaultMQPushConsumer = RocketConsumerFactory.getRocketConsumer(consumerGroup, this.messageRegistryVo);
            defaultMQPushConsumer.subscribe(topicName, routingKey);
            if (messageModel != null) {
                defaultMQPushConsumer.setMessageModel(messageModel);
            } else {
                defaultMQPushConsumer.setMessageModel(MessageModel.CLUSTERING);
            }
            if (messageModel == null) {
                defaultMQPushConsumer.registerMessageListener(this.createOrderlyMessageListener(processor));
            } else {
                defaultMQPushConsumer.registerMessageListener(this.createMessageConcurrentlyListener(processor));
            }
            ServiceState serviceState = defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getServiceState();
            if (serviceState.equals((Object)ServiceState.CREATE_JUST)) {
                defaultMQPushConsumer.start();
            }
            logger.info("ConsumerStarted.");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey, e});
            throw new BusinessRuntimeException("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:" + topicName + ",consumer:" + consumer + ",routingKey:" + routingKey, (Throwable)e);
        }
    }

    private <T> MessageListenerConcurrently createMessageConcurrentlyListener(final IMessageProcessor<T> processor) {
        return new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                MessageExt msg = msgs.get(0);
                if (logger.isInfoEnabled()) {
                    logger.info("\u63a5\u6536\u5230\u6d88\u606f,topic={},tags={},msgId:{},msgKeys={}", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId(), msg.getKeys()});
                }
                if (processor == null) {
                    logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005,topic={},tags={},msgId:{},msgKeys={},\u76f4\u63a5\u4e22\u5f03\uff01", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId(), msg.getKeys()});
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                MQMessageVo messageVo = MessageAssembler.messageExtToVo(msg, RocketConsumer.this.messageRegistryVo.getSerializeCode());
                messageVo.setPassSvcContext(RocketConsumer.this.messageRegistryVo.isPassSvcContext());
                MessageResponse response = processor.process(messageVo);
                if (response == null || "error".equals(response.getResultMsg())) {
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        };
    }

    private <T> MessageListenerOrderly createOrderlyMessageListener(final IMessageProcessor<T> processor) {
        return new MessageListenerOrderly(){

            public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
                context.setAutoCommit(true);
                MessageExt msg = msgs.get(0);
                if (logger.isInfoEnabled()) {
                    logger.info("\u63a5\u6536\u5230\u6d88\u606f,topic={},tags={},msgId:{},msgKeys={}", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId(), msg.getKeys()});
                }
                if (processor == null) {
                    logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005,topic={},tags={},msgId:{},msgKeys={},\u76f4\u63a5\u4e22\u5f03\uff01", new Object[]{msg.getTopic(), msg.getTags(), msg.getMsgId(), msg.getKeys()});
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                MQMessageVo messageVo = MessageAssembler.messageExtToVo(msg, RocketConsumer.this.messageRegistryVo.getSerializeCode());
                try {
                    MessageResponse response = processor.process(messageVo);
                    if (!MessageResponse.SUCCESS.equals(response)) {
                        return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                    }
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                catch (Throwable e) {
                    if (logger.isDebugEnabled()) {
                        logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a", e);
                    } else {
                        logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)e.getMessage());
                    }
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
        };
    }

    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        if (logger.isInfoEnabled()) {
            logger.info("subscribe,topicName:{},routingKeys:{}", (Object)topicName, (Object)routingKeys);
        }
        return this.subscribe(topicName, this.getSubExpression(routingKeys), processor);
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topicName, this.messageRegistryVo.getConsumerId(), routingKey, processor, MessageModel.BROADCASTING);
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        return this.toSubscribeMessage(topicName, this.messageRegistryVo.getConsumerId(), this.getSubExpression(routingKeys), processor, MessageModel.BROADCASTING);
    }

    public MessageResponse unsubscribe(String topicName, String routingKey) {
        try {
            String consumer = this.messageRegistryVo.getConsumerId() != null ? this.messageRegistryVo.getConsumerId() : "";
            String consumerGroup = String.format(CONSUMER_GROUP_FORMATER, consumer, topicName, routingKey);
            DefaultMQPushConsumer defaultMQPushConsumer = RocketConsumerFactory.getRocketConsumer(consumerGroup, this.messageRegistryVo);
            defaultMQPushConsumer.unsubscribe(topicName);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u9605\u5931\u8d25\uff0ctopicName\uff1a{}", (Object)topicName, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }
}

