/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.assembler;

import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MessageAssembler {
    private static final long[] DELAY_TIMES = new long[]{0L, 1L, 5L, 10L, 30L, 60L, 120L, 180L, 240L, 300L, 420L, 480L, 540L, 600L, 1200L, 1800L, 3600L, 7200L};

    private MessageAssembler() {
    }

    public static MQMessageVo messageExtToVo(MessageExt messageExt, SerializeCode serializeCode) {
        MQMessageVo messageVo = new MQMessageVo(serializeCode);
        messageVo.setTopic(messageExt.getTopic());
        messageVo.setTag(messageExt.getTags());
        messageVo.setMessageBody(messageExt.getBody());
        messageVo.setDelayTime(MessageAssembler.getDelayTime(messageExt.getDelayTimeLevel()));
        messageVo.setMessageKey(messageExt.getKeys());
        messageVo.setMessageId(messageExt.getMsgId());
        HashMap headerList = new HashMap(messageExt.getProperties().size());
        messageExt.getProperties().forEach((key, value) -> {
            if (MessageConst.STRING_HASH_SET.contains(key)) {
                return;
            }
            if (key.equals("mqMessageBodyClassInfo")) {
                messageVo.setMessageBodyClass(value);
            } else {
                headerList.put(key, value);
            }
        });
        messageVo.setHeaderList(headerList);
        return messageVo;
    }

    public static Message messageVoToMessage(MQMessageVo messageVo) {
        Message message = new Message(messageVo.getTopic(), messageVo.getTag(), messageVo.getMessageKey(), messageVo.getMessageBody());
        if (messageVo.getDelayTime() > 0L) {
            message.setDelayTimeLevel(MessageAssembler.getDelayTimeLevel(messageVo.getDelayTime()));
        }
        if (!CollectionUtils.isEmpty((Map)messageVo.getHeaderList())) {
            messageVo.getHeaderList().forEach((key, value) -> message.putUserProperty(key, value));
        }
        if (messageVo.getSerializeCode().isJdkSerializer()) {
            return message;
        }
        if (!StringUtils.isEmpty((Object)messageVo.getMessageBodyClass())) {
            message.putUserProperty("mqMessageBodyClassInfo", messageVo.getMessageBodyClass());
        }
        return message;
    }

    private static long getDelayTime(int delayTimeLevel) {
        if (delayTimeLevel < DELAY_TIMES.length) {
            return DELAY_TIMES[delayTimeLevel];
        }
        return 0L;
    }

    private static int getDelayTimeLevel(long delayTime) {
        if (delayTime <= 1L) {
            return 1;
        }
        if (delayTime <= 5L) {
            return 2;
        }
        if (delayTime <= 10L) {
            return 3;
        }
        if (delayTime <= 30L) {
            return 4;
        }
        if (delayTime <= 60L) {
            return 5;
        }
        if (delayTime <= 120L) {
            return 6;
        }
        if (delayTime <= 180L) {
            return 7;
        }
        if (delayTime <= 240L) {
            return 8;
        }
        if (delayTime <= 300L) {
            return 9;
        }
        if (delayTime <= 360L) {
            return 10;
        }
        if (delayTime <= 420L) {
            return 11;
        }
        if (delayTime <= 480L) {
            return 12;
        }
        if (delayTime <= 540L) {
            return 13;
        }
        if (delayTime <= 600L) {
            return 14;
        }
        if (delayTime <= 1200L) {
            return 15;
        }
        if (delayTime <= 1800L) {
            return 16;
        }
        if (delayTime <= 3600L) {
            return 17;
        }
        if (delayTime <= 7200L) {
            return 18;
        }
        return 18;
    }
}

