/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq.impl;

import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.MQProcessorRegisterDto;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DefaultMQConsumerRegister
implements EnvironmentAware,
BeanFactoryAware,
IMQConsumerRegister {
    private ListableBeanFactory beanFactory;
    private final TopicRegistryVo topicRegistryVo;
    private final MessageRegistryVo registryVo;
    private final String consumer;
    private Environment environment;

    public DefaultMQConsumerRegister(MessageRegistryVo registryVo, TopicRegistryVo topicRegistryVo, String consumer) {
        this.registryVo = registryVo;
        this.topicRegistryVo = topicRegistryVo;
        this.consumer = consumer;
    }

    @Override
    public List<MQProcessorRegisterDto> getMQProcessorRegisters() {
        ArrayList<MQProcessorRegisterDto> registeredProcessorList = new ArrayList<MQProcessorRegisterDto>();
        Collection messageProcessors = this.beanFactory.getBeansOfType(IMessageProcessor.class).values();
        for (IMessageProcessor bean : messageProcessors) {
            Class<?> beanClass = AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.ultimateTargetClass((Object)bean) : bean.getClass();
            MQDesc mqDesc = beanClass.getAnnotation(MQDesc.class);
            if (null == mqDesc) continue;
            String topic = this.environment.resolvePlaceholders(mqDesc.topic());
            String consumer = CommonsMqHelper.parseConsumer(this.registryVo, mqDesc.consumer(), this.consumer);
            String tag = this.environment.resolvePlaceholders(mqDesc.tag());
            String msgType = mqDesc.msgType();
            if (StringUtils.isBlank((CharSequence)topic)) {
                topic = "single".equals(mqDesc.msgType()) ? this.topicRegistryVo.getSingleTopic() : this.topicRegistryVo.getPublishTopic();
            }
            MQProcessorRegisterDto mqProcessorRegisterDto = new MQProcessorRegisterDto();
            mqProcessorRegisterDto.setTopic(topic);
            mqProcessorRegisterDto.setConsumer(consumer);
            mqProcessorRegisterDto.setTag(tag);
            mqProcessorRegisterDto.setMsgType(msgType);
            mqProcessorRegisterDto.setBean(bean);
            registeredProcessorList.add(mqProcessorRegisterDto);
        }
        return registeredProcessorList;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

