/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.aliyun.util.AliyunConsumerHelper;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(AliyunConsumer.class);
    private static final String SUBSCRIBE_TYPE = "subscribe";
    private static final AliyunConsumer single = new AliyunConsumer();
    private Consumer consumer;

    private AliyunConsumer() {
    }

    public static AliyunConsumer getInstance() {
        return single;
    }

    public void createConsumer(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
    }

    @Override
    public <T> MessageResponse receiveMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        logger.info("receiveMessage,topicName:{},routingKey:{}", (Object)topicName, (Object)routingKey);
        return this.subscribe(topicName, routingKey, processor);
    }

    @Override
    public <T> MessageResponse receiveMessage(String topic, String queueName, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topic, queueName, routingKey, processor);
    }

    @Override
    public MessageResponse receiveMessage(String topic, String queueName, Map<String, IMessageProcessor> processorMap) {
        return this.subscribe(topic, queueName, processorMap);
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String queueName, String routingKey, IMessageProcessor<T> processor) {
        logger.info("subscribeMessage,topicName:{},queueName:{},routingKey:{}", new Object[]{topicName, queueName, routingKey});
        try {
            this.toSubscribe(this.messageRegistryVo, topicName, queueName, routingKey, processor, SUBSCRIBE_TYPE);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queueName:{}", new Object[]{topicName, routingKey, e});
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        try {
            this.toSubscribe(this.messageRegistryVo, topicName, routingKey, processor, SUBSCRIBE_TYPE);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queueName:{}", new Object[]{topicName, routingKey, e});
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        try {
            String subExpression = this.getSubExpression(routingKeys);
            this.toSubscribe(this.messageRegistryVo, topicName, subExpression, processor, SUBSCRIBE_TYPE);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topicName, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public MessageResponse subscribe(String topic, Map<String, IMessageProcessor> messageProcessorMap) {
        return this.subscribe(topic, this.messageRegistryVo.getConsumerId(), messageProcessorMap);
    }

    @Override
    public MessageResponse subscribe(String topic, String queueName, Map<String, IMessageProcessor> messageProcessorMap) {
        try {
            this.toSubscribe(this.messageRegistryVo, topic, queueName, messageProcessorMap, SUBSCRIBE_TYPE);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, final Map<String, IMessageProcessor> messageProcessorMap, String type) {
        try {
            Properties properties = super.getProperties(messageRegistryVo);
            properties.setProperty("ConsumerId", consumerId);
            properties.setProperty("NAMESRV_ADDR", messageRegistryVo.getHost());
            properties.setProperty("ConsumeThreadNums", String.valueOf(messageRegistryVo.getConsumeThreadNums()));
            this.consumer = ONSFactory.createConsumer((Properties)properties);
            if (SUBSCRIBE_TYPE.equals(type)) {
                String subExpression = this.getSubExpression(messageProcessorMap.keySet().toArray());
                this.consumer.subscribe(topicName, subExpression, new MessageListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Action consume(Message message, ConsumeContext context) {
                        logger.info("Receive message success! message:{}" + message.toString());
                        AliyunConsumerHelper.setMsgfo(message);
                        AliyunConsumerHelper.setMsgId(message.getMsgID());
                        try {
                            MessageResponse result = ((IMessageProcessor)messageProcessorMap.get(message.getTag())).process(SerializeCode.deSerialize(message.getBody()));
                            if (result != null) {
                                if ("error".equals(result.getResultMsg())) {
                                    Action action = Action.ReconsumeLater;
                                    return action;
                                }
                                Action action = Action.CommitMessage;
                                return action;
                            }
                            Action action = Action.CommitMessage;
                            return action;
                        }
                        catch (Exception e) {
                            Action action = Action.ReconsumeLater;
                            return action;
                        }
                        finally {
                            AliyunConsumerHelper.clearThreadInfo();
                        }
                    }
                });
            } else {
                this.consumer.unsubscribe(topicName);
            }
            this.consumer.start();
            logger.info("Connected to {}", (Object)messageRegistryVo.getHost());
        }
        catch (Exception e) {
            logger.info("Failed to connect to {}", (Object)messageRegistryVo.getHost(), (Object)e);
        }
    }

    @Override
    public MessageResponse unsubscribe(String topicName, String routingKey) {
        try {
            this.toSubscribe(this.messageRegistryVo, topicName, null, null, null, null);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u9605\u5931\u8d25\uff0ctopicName\uff1a{}", (Object)topicName, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, String routingKey, IMessageProcessor processor, String type) {
        HashMap<String, IMessageProcessor> messageProcessorMap = new HashMap<String, IMessageProcessor>();
        messageProcessorMap.put(routingKey, processor);
        this.toSubscribe(messageRegistryVo, topicName, consumerId, messageProcessorMap, type);
    }

    private <T> void toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String routingKey, IMessageProcessor<T> processor, String type) {
        this.toSubscribe(messageRegistryVo, topicName, messageRegistryVo.getConsumerId(), routingKey, processor, type);
    }
}

