/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.MQConstants;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunProducer
extends AbstractProducer {
    private static Logger logger = LoggerFactory.getLogger(AliyunProducer.class);
    private static final AliyunProducer single = new AliyunProducer();
    private Producer producer;

    private AliyunProducer() {
    }

    public static AliyunProducer getInstance() {
        return single;
    }

    public void createProducer(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
        this.start(messageRegistryVo);
    }

    @Override
    protected void start(MessageRegistryVo messageRegistryVo) {
        try {
            Properties properties = super.getProperties(messageRegistryVo);
            properties.setProperty("ProducerId", messageRegistryVo.getProducerId());
            properties.setProperty("NAMESRV_ADDR", messageRegistryVo.getHost());
            this.producer = ONSFactory.createProducer((Properties)properties);
            this.producer.start();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaAliyun Producer\u65f6\u51fa\u9519\uff0c host:{},username:{},password{}", new Object[]{messageRegistryVo.getHost(), messageRegistryVo.getUsername(), messageRegistryVo.getPassword(), e});
            logger.error(e.getMessage(), (Throwable)e);
            this.asyncWaitAndReconnect(messageRegistryVo);
        }
    }

    @Override
    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        return this.sendMessage(topicName, queueName, message, delayTime);
    }

    @Override
    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        String messageId = "";
        try {
            if (this.producer != null) {
                Message msg = new Message(topicName, routingKey, SerializeCode.serialize(message));
                msg.setKey("ORDERID_" + this.getMessageId());
                if (delayTime > 0L) {
                    msg.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
                }
                logger.info("\u53d1\u9001MQ\u6d88\u606f\uff0ctopicName\uff1a{} routingKey:{}, key:{}", new Object[]{this.messageRegistryVo.getTopicName(), routingKey, msg.getKey()});
                SendResult result = this.producer.send(msg);
                messageId = result.getMessageId();
                logger.info("\u53d1\u9001MQ\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)messageId);
            } else {
                this.asyncWaitAndReconnect(this.messageRegistryVo);
            }
            return new MessageResponse(messageId);
        }
        catch (Exception e) {
            this.saveMqLog(topicName, null, routingKey, message, MQConstants.MQ_SEDN_TYPE_PUB, e.getMessage(), message.getClass().getName(), "sendMessage");
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{this.messageRegistryVo.getTopicName(), routingKey, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    @Override
    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(topic, queueName, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncMessage(this.messageRegistryVo.getTopicName(), routingKey, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String topic, String routingKey, Object message, long delayTime, SendCallback callback) {
        try {
            if (this.producer != null) {
                this.producer.start();
                Message msg = new Message(topic, routingKey, SerializeCode.serialize(message));
                msg.setKey("ORDERID_" + this.getMessageId());
                if (delayTime > 0L) {
                    msg.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
                }
                logger.info("\u5f00\u59cb\u53d1\u9001\u5f02\u6b65\u6d88\u606f,topic:{}, tag:{},key:{}", new Object[]{msg.getTopic(), msg.getTag(), msg.getKey()});
                this.sendAsync(msg, callback);
            } else {
                this.asyncWaitAndReconnect(this.messageRegistryVo);
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            this.saveMqLog(topic, null, routingKey, message, MQConstants.MQ_SEDN_TYPE_PUB, e.getMessage(), message.getClass().getName(), "sendAsyncMessage");
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{this.messageRegistryVo.getTopicName(), routingKey, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    private void sendAsync(final Message msg, final SendCallback callback) {
        this.producer.sendAsync(msg, new com.aliyun.openservices.ons.api.SendCallback(){

            public void onSuccess(SendResult sendResult) {
                logger.info("\u53d1\u9001\u5f02\u6b65\u6d88\u606f\u6210\u529f! Topic is {}, tag:{},msgId is: {}, key:{}", new Object[]{sendResult.getTopic(), msg.getTag(), sendResult.getMessageId(), msg.getKey()});
                callback.onSuccess(sendResult.getMessageId());
            }

            public void onException(OnExceptionContext context) {
                logger.info("\u53d1\u9001\u5f02\u6b65\u6d88\u606f\u51fa\u9519! Topic is {}, msgId is: {}, key:{}", new Object[]{context.getTopic(), context.getMessageId(), msg.getKey()});
                callback.onException((Exception)context.getException(), context.getMessageId());
            }
        });
    }
}

