/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.provider.base.BaseService;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager
extends BaseService {
    private static Logger logger = LoggerFactory.getLogger(MessageManager.class);
    Channel channel;

    public void exchangeDeclare(String exchangeName) throws IOException {
        logger.info("channel={}, exchangeName={}", (Object)this.channel, (Object)exchangeName);
        this.channel.exchangeDeclare(exchangeName, "direct", this.durable, false, null);
    }

    public void declareQueue(String queueName, String exchangeName, long delayTime) throws IOException {
        logger.info("queueName={}, exchangeName={}, delayTime={}", new Object[]{this.channel, exchangeName, delayTime});
        this.declareMessageQueue(queueName, exchangeName, delayTime, this.channel);
    }

    protected AMQP.Queue.BindOk declareMessageQueue(String queueName, String exchangeName, long delayTime, Channel channel) throws IOException {
        this.getTempMessage(queueName, exchangeName, delayTime, channel);
        channel.queueDeclare(queueName, this.durable, false, false, null);
        return channel.queueBind(queueName, exchangeName, queueName);
    }

    public void declareMessageDelayQueue(String routingKey, String exchangeName, long delayTime) throws IOException {
        this.getTempMessage(routingKey, exchangeName, delayTime, this.channel);
    }

    public String sendMessage(String routingKey, String exchangeName, long delayTime, Object message) throws IOException {
        this.declareMessageQueue(routingKey, exchangeName, delayTime, this.channel);
        String messageId = this.getMessageId();
        byte[] bytes = SerializeCode.serialize(message);
        if (delayTime > 0L) {
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().contentEncoding("UTF-8").messageId(messageId).deliveryMode(Integer.valueOf(2)).expiration(String.valueOf(delayTime * 1000L)).build();
            this.channel.basicPublish("delay." + exchangeName, "delay." + routingKey + "_" + delayTime, props, bytes);
        } else {
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().contentEncoding("UTF-8").messageId(messageId).deliveryMode(Integer.valueOf(2)).build();
            this.channel.basicPublish(exchangeName, routingKey, props, bytes);
        }
        return messageId;
    }

    private void getTempMessage(String routingKey, String exchangeName, long delayTime, Channel channel) throws IOException {
        if (delayTime > 0L) {
            String queueName = routingKey;
            String delayExchange = "delay." + exchangeName;
            String delayQueue = "delay." + queueName + "_" + delayTime;
            String delayRoutingKey = "delay." + routingKey + "_" + delayTime;
            channel.exchangeDeclare(delayExchange, "direct", false, true, null);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("x-dead-letter-exchange", exchangeName);
            args.put("x-dead-letter-routing-key", routingKey);
            channel.queueDeclare(delayQueue, this.durable, false, true, args);
            channel.queueBind(delayQueue, delayExchange, delayRoutingKey);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String toString() {
        return "MessageManager [" + (this.channel != null ? "channel=" + this.channel + ", " : "") + (this.executor != null ? "executor=" + this.executor + ", " : "") + (this.messageRegistryVo != null ? "messageRegistryVo=" + this.messageRegistryVo + ", " : "") + "durable=" + this.durable + ", prefetchCount=" + this.prefetchCount + ", autoAck=" + this.autoAck + "]";
    }
}

